/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallColonyManage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutTownHall
extends AbstractBlockHut<BlockHutTownHall> {
    private int breakProgressOnTownHall = 0;
    private long lastTownHallBreakingTick = 0L;
    private boolean validTownHallBreak = false;

    public BlockHutTownHall() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(10.0f, Float.POSITIVE_INFINITY));
    }

    @Override
    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter blockReader, @NotNull BlockPos pos) {
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && player.f_19853_ instanceof ServerLevel) {
            IBuilding building = IColonyManager.getInstance().getBuilding(player.f_19853_, pos);
            if (building != null && building.getColony().isCoordInColony(player.f_19853_, pos) && building.getColony().getPermissions().getRank(player).isHostile()) {
                double localProgress = this.breakProgressOnTownHall;
                double hardness = (double)state.m_60800_((BlockGetter)player.f_19853_, pos) * 20.0 * 1.5;
                if (localProgress >= hardness / 10.0 * 9.0 && localProgress <= hardness / 10.0 * 9.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.m_7755_(), 90);
                }
                if (localProgress >= hardness / 4.0 * 3.0 && localProgress <= hardness / 4.0 * 3.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.m_7755_(), 75);
                } else if (localProgress >= hardness / 2.0 && localProgress <= hardness / 2.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.m_7755_(), 50);
                } else if (localProgress >= hardness / 4.0 && localProgress <= hardness / 4.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.m_7755_(), 25);
                }
                if (localProgress >= hardness - 1.0) {
                    this.validTownHallBreak = true;
                }
                if (player.f_19853_.m_46467_() - this.lastTownHallBreakingTick < 10L) {
                    ++this.breakProgressOnTownHall;
                } else {
                    this.sendPlayersMessage(building.getColony().getImportantMessageEntityPlayers(), "com.minecolonies.coremod.pvp.townhall.break.start", player.m_7755_(), 100);
                    this.breakProgressOnTownHall = 0;
                    this.validTownHallBreak = false;
                }
                this.lastTownHallBreakingTick = player.f_19853_.m_46467_();
            } else {
                this.validTownHallBreak = true;
            }
        } else if (!((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue()) {
            this.validTownHallBreak = true;
        }
        float def = super.m_5880_(state, player, (BlockGetter)player.f_19853_, pos);
        return (Boolean)MineColonies.getConfig().getServer().pvp_mode.get() != false ? def / 12.0f : def / 10.0f;
    }

    private void sendPlayersMessage(List<Player> players, String key, Component attacker, int value) {
        for (Player player : players) {
            player.m_6352_((Component)new TranslatableComponent(key, new Object[]{attacker, value}), player.m_142081_());
        }
    }

    public boolean getValidBreak() {
        return this.validTownHallBreak;
    }

    @Override
    @NotNull
    public String getHutName() {
        return "blockhuttownhall";
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return ModBuildings.townHall;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), pos);
            if (building != null && building.getColony() != null && building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                building.openGui(player.m_6144_());
            } else {
                new WindowTownHallColonyManage(player, pos, worldIn).open();
            }
        }
        return InteractionResult.SUCCESS;
    }
}

