/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.citizen.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RestartCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends AbstractWindowSkeleton {
    protected final AbstractBuildingView building;
    protected final IColonyView colony;
    protected List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    protected final ScrollingList citizenList;
    protected final ScrollingList jobList;
    protected final List<IAssignmentModuleView> moduleViews = new ArrayList<IAssignmentModuleView>();
    protected IAssignmentModuleView selectedModule;

    public WindowHireWorker(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingView)this.colony.getBuilding(buildingId);
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unemployed", ScrollingList.class);
        this.jobList = (ScrollingList)this.findPaneOfTypeByID("jobs", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("done", this::doneClicked);
        super.registerButton("fire", this::fireClicked);
        super.registerButton("pause", this::pauseClicked);
        super.registerButton("restart", this::restartClicked);
        super.registerButton("mode", this::modeClicked);
        super.registerButton("job", this::jobClicked);
        this.moduleViews.addAll(this.building.getModuleViews(IAssignmentModuleView.class));
        this.selectedModule = this.moduleViews.get(0);
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.selectedModule.getHiringMode().ordinal() + 1;
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.selectedModule.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.hiringmode." + this.selectedModule.getHiringMode().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
    }

    private void restartClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        Network.getNetwork().sendToServer(new RestartCitizenMessage(this.building, id));
        this.close();
    }

    private void pauseClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        Network.getNetwork().sendToServer(new PauseCitizenMessage(this.building, id));
        citizen.setPaused(!citizen.isPaused());
    }

    private void fireClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        this.selectedModule.removeCitizen(citizen);
        this.onOpened();
    }

    private void doneClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        @NotNull ICitizenDataView citizen = this.citizens.get(row);
        this.selectedModule.addCitizen(citizen);
        this.onOpened();
    }

    private void jobClicked(@NotNull Button button) {
        int row = this.jobList.getListElementIndexByPane((Pane)button);
        this.selectedModule = this.moduleViews.get(row);
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
        this.updateCitizens();
        this.citizenList.refreshElementPanes();
        this.jobList.refreshElementPanes();
    }

    protected void updateCitizens() {
        this.citizens.clear();
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> this.selectedModule.canAssign((ICitizenDataView)citizen)).sorted(Comparator.comparing(ICitizen::getName)).collect(Collectors.toList());
        this.citizens.sort((c1, c2) -> {
            int i1 = this.building.getPosition().equals((Object)c1.getWorkBuilding()) ? -1 : 0;
            int i2 = this.building.getPosition().equals((Object)c2.getWorkBuilding()) ? -1 : 0;
            return Integer.compare(i1, i2);
        });
    }

    public void onOpened() {
        this.updateCitizens();
        ((Text)this.findPaneOfTypeByID("autoHireWarn", Text.class)).off();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = WindowHireWorker.this.citizens.get(index);
                Button isPaused = (Button)rowPane.findPaneOfTypeByID("pause", Button.class);
                if (WindowHireWorker.this.selectedModule.canAssign(citizen) && !WindowHireWorker.this.selectedModule.isFull() && !WindowHireWorker.this.selectedModule.getAssignedCitizens().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).on();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else if (WindowHireWorker.this.selectedModule.isFull() && !WindowHireWorker.this.selectedModule.getAssignedCitizens().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).on();
                    if (!WindowHireWorker.this.selectedModule.getColony().isManualHiring() && WindowHireWorker.this.selectedModule.getHiringMode() == HiringMode.DEFAULT || WindowHireWorker.this.selectedModule.getHiringMode() == HiringMode.AUTO) {
                        ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).disable();
                        ((Text)WindowHireWorker.this.findPaneOfTypeByID("autoHireWarn", Text.class)).on();
                    }
                    isPaused.on();
                    isPaused.setText((MutableComponent)new TranslatableComponent(citizen.isPaused() ? "com.minecolonies.coremod.gui.hiring.buttonunpaused" : "com.minecolonies.coremod.gui.hiring.buttonpaused"));
                }
                if (citizen.isPaused()) {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).on();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                }
                TextComponent intermString = new TextComponent(" ");
                AbstractTextBuilder.TextBuilder textBuilder = PaneBuilders.textBuilder();
                textBuilder.append((MutableComponent)new TextComponent(""));
                int skillCount = citizen.getCitizenSkillHandler().getSkills().entrySet().size();
                Skill primary = WindowHireWorker.this.selectedModule instanceof WorkerBuildingModuleView ? ((WorkerBuildingModuleView)WindowHireWorker.this.selectedModule).getPrimarySkill() : null;
                Skill secondary = WindowHireWorker.this.selectedModule instanceof WorkerBuildingModuleView ? ((WorkerBuildingModuleView)WindowHireWorker.this.selectedModule).getSecondarySkill() : null;
                for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
                    String skillName = entry.getKey().name().toLowerCase(Locale.US);
                    int skillLevel = (Integer)entry.getValue().m_14418_();
                    Style skillStyle = WindowHireWorker.this.createColor(primary, secondary, entry.getKey());
                    textBuilder.append(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.skills." + skillName).m_6270_(skillStyle));
                    textBuilder.append(new TextComponent(": " + skillLevel).m_6270_(skillStyle));
                    if (--skillCount <= 0) continue;
                    textBuilder.append((MutableComponent)intermString);
                }
                textBuilder.newLine();
                ((Text)rowPane.findPaneOfTypeByID("citizen", Text.class)).setText((String)(citizen.getJob().isEmpty() ? "" : new TranslatableComponent(citizen.getJob().toLowerCase(Locale.ROOT)).getString() + ": ") + citizen.getName());
                ((Text)rowPane.findPaneOfTypeByID("attributes", Text.class)).setText(textBuilder.getText());
            }
        });
        this.jobList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHireWorker.this.moduleViews.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                JobEntry entry = WindowHireWorker.this.moduleViews.get(index).getJobEntry();
                Button button = (Button)rowPane.findPaneOfTypeByID("job", Button.class);
                button.setText((MutableComponent)new TranslatableComponent(entry.getTranslationKey()));
                if (entry.equals((Object)WindowHireWorker.this.selectedModule.getJobEntry())) {
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
    }

    protected Style createColor(Skill primary, Skill secondary, Skill current) {
        if (primary == current) {
            return Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131157_(ChatFormatting.BOLD);
        }
        if (secondary == current) {
            return Style.f_131099_.m_131157_(ChatFormatting.YELLOW).m_131157_(ChatFormatting.ITALIC);
        }
        return Style.f_131099_;
    }
}

