/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.huts;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowModuleBuilding;
import com.minecolonies.coremod.client.gui.WindowAssignCitizen;
import com.minecolonies.coremod.colony.buildings.modules.HomeBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.RecallCitizenHutMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutCitizen
extends AbstractWindowModuleBuilding<HomeBuildingModule.View> {
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowhuthome.xml";
    private final HomeBuildingModule.View home;
    private ScrollingList citizen;

    public WindowHutCitizen(HomeBuildingModule.View building) {
        super(building, "minecolonies:gui/windowhuthome.xml");
        super.registerButton("assign", this::assignClicked);
        super.registerButton("remove", this::removeClicked);
        super.registerButton("recall", this::recallClicked);
        this.home = building;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final boolean isManualHousing = ((HomeBuildingModule.View)this.building).getColony().isManualHousing();
        this.citizen = (ScrollingList)this.findPaneOfTypeByID("assignedCitizen", ScrollingList.class);
        this.citizen.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutCitizen.this.home.getResidents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowHutCitizen.this.home.getColony().getCitizen(WindowHutCitizen.this.home.getResidents().get(index));
                if (citizenDataView != null) {
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(citizenDataView.getName());
                    ((Button)rowPane.findPaneOfTypeByID("remove", Button.class)).setEnabled(isManualHousing);
                    if (citizenDataView.getWorkBuilding() != null) {
                        BlockPos work = citizenDataView.getWorkBuilding();
                        double distance2D = BlockPosUtil.getDistance2D(work, WindowHutCitizen.this.home.getPosition());
                        ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.dist.blocks", new Object[]{distance2D}));
                    }
                }
            }
        });
        this.refreshView();
    }

    private void refreshView() {
        Button buttonAssign = (Button)this.findPaneOfTypeByID("assign", Button.class);
        int sparePlaces = ((HomeBuildingModule.View)this.building).getBuildingLevel() - ((HomeBuildingModule.View)this.building).getResidents().size();
        buttonAssign.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.home.assign", new Object[]{sparePlaces}));
        buttonAssign.setEnabled(sparePlaces > 0 && ((HomeBuildingModule.View)this.building).getColony().isManualHousing());
        this.citizen.refreshElementPanes();
    }

    private void assignClicked() {
        if (((HomeBuildingModule.View)this.building).getColony().isManualHousing()) {
            if (((HomeBuildingModule.View)this.building).getBuildingLevel() == 0) {
                LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"com.minecolonies.coremod.gui.workerhuts.level0", (Object[])new Object[0]);
                return;
            }
            if (((HomeBuildingModule.View)this.building).getResidents().size() < ((HomeBuildingModule.View)this.building).getBuildingLevel()) {
                @NotNull WindowAssignCitizen window = new WindowAssignCitizen(((HomeBuildingModule.View)this.building).getColony(), ((HomeBuildingModule.View)this.building).getPosition());
                window.open();
            }
        }
    }

    private void removeClicked(@NotNull Button button) {
        if (((HomeBuildingModule.View)this.building).getColony().isManualHousing()) {
            int row = this.citizen.getListElementIndexByPane((Pane)button);
            int citizenid = this.home.getResidents().get(row);
            this.home.removeResident(row);
            Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, false, citizenid, null));
            this.refreshView();
        }
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenHutMessage((AbstractBuildingView)this.building));
    }
}

