/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowListRecipes
extends AbstractModuleWindow {
    private static final String RECIPE_LIST = "recipes";
    private static final String RECIPE_STATUS = "recipestatus";
    private static final String OUTPUT_ICON = "output";
    private static final String RESOURCE = "res%d";
    private final CraftingModuleView module;
    private final ScrollingList recipeList;
    private static final String BUTTON_CRAFTING = "crafting";
    private final Text recipeStatus;
    private int lifeCount = 0;

    public WindowListRecipes(IBuildingView view, String name, CraftingModuleView module) {
        super(view, name);
        this.module = module;
        this.recipeList = (ScrollingList)this.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class);
        this.recipeStatus = (Text)this.findPaneOfTypeByID(RECIPE_STATUS, Text.class);
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CRAFTING, ButtonImage.class)).setVisible(module.isRecipeAlterationAllowed());
        ((Text)this.findPaneOfTypeByID(RECIPE_STATUS, Text.class)).setVisible(module.isRecipeAlterationAllowed());
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton("remove", this::removeClicked);
        super.registerButton("up", this::forwardClicked);
        super.registerButton("down", this::backwardClicked);
    }

    private void backwardClicked(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        this.module.switchOrder(row, row + 1);
        Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.buildingView, row, false, this.module.getId()));
        this.recipeList.refreshElementPanes();
    }

    private void forwardClicked(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        this.module.switchOrder(row, row - 1);
        Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.buildingView, row, true, this.module.getId()));
        this.recipeList.refreshElementPanes();
    }

    private void removeClicked(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        IRecipeStorage data = this.module.getRecipes().get(row);
        this.module.removeRecipe(row);
        this.recipeList.refreshElementPanes();
        Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(this.buildingView, true, data, this.module.getId()));
    }

    public void craftingClicked() {
        if (!this.module.isRecipeAlterationAllowed()) {
            return;
        }
        this.module.openCraftingGUI();
    }

    public void onOpened() {
        this.recipeList.enable();
        this.recipeList.show();
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowListRecipes.this.module.getRecipes().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Button removeButton;
                @NotNull IRecipeStorage recipe = WindowListRecipes.this.module.getRecipes().get(index);
                ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID(WindowListRecipes.OUTPUT_ICON, ItemIcon.class);
                List<ItemStack> displayStacks = recipe.getRecipeType().getOutputDisplayStacks();
                icon.setItem(displayStacks.get(WindowListRecipes.this.lifeCount / 30 % displayStacks.size()));
                if (!WindowListRecipes.this.module.canLearnCraftingRecipes() && !WindowListRecipes.this.module.canLearnFurnaceRecipes() && (removeButton = (Button)rowPane.findPaneOfTypeByID("remove", Button.class)) != null) {
                    removeButton.setVisible(false);
                }
                Text intermediate = (Text)rowPane.findPaneOfTypeByID("intermediate", Text.class);
                if (recipe.getIntermediate() != Blocks.f_50016_) {
                    intermediate.setText(recipe.getIntermediate().m_49954_());
                }
                intermediate.setVisible(false);
                if (recipe.getInput().size() < 4) {
                    for (int i = 0; i < 9; ++i) {
                        if (i < recipe.getInput().size()) {
                            ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                            continue;
                        }
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    }
                } else if (recipe.getInput().size() == 4) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(0)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 2), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(1)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 3), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 4), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(2)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 5), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(3)));
                    for (int i = 6; i < 9; ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    }
                } else {
                    for (int i = 0; i < recipe.getInput().size(); ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                    }
                }
            }
        });
    }

    private ItemStack getStackWithCount(ItemStorage storage) {
        ItemStack displayItem = storage.getItemStack();
        displayItem.m_41764_(storage.getAmount());
        return displayItem;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.m_96638_()) {
            ++this.lifeCount;
        }
        this.recipeStatus.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.recipestatus", new Object[]{this.module.getRecipes().size(), this.module.getMaxRecipes()}));
        ((ScrollingList)this.window.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class)).refreshElementPanes();
    }
}

