/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.WorkOrderView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.SettingsModuleView;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkOrderListModuleView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.server.colony.WorkOrderChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.builder.BuilderSelectWorkOrderMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderModuleWindow
extends AbstractModuleWindow {
    private final List<WorkOrderView> workOrders = new ArrayList<WorkOrderView>();
    private ScrollingList workOrdersList;
    private boolean manualMode;
    private int tick = 0;

    public WorkOrderModuleWindow(String res, IBuildingView building, WorkOrderListModuleView moduleView) {
        super(building, res);
        ((Text)this.window.findPaneOfTypeByID("desc", Text.class)).setText((MutableComponent)new TranslatableComponent(moduleView.getDesc().toLowerCase(Locale.US)));
        this.registerButton("manage", this::selectWorkOrder);
    }

    public void onOpened() {
        super.onOpened();
        this.manualMode = this.buildingView.getModuleView(SettingsModuleView.class).getSetting(BuildingBuilder.MODE).getValue().equals("com.minecolonies.core.builder.setting.manual");
        this.workOrdersList = (ScrollingList)this.findPaneOfTypeByID("workOrders", ScrollingList.class);
        this.workOrdersList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WorkOrderModuleWindow.this.workOrders.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WorkOrderModuleWindow.this.updateAvailableWorkOrders(index, rowPane);
            }
        });
        this.updateWorkOrders();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick++ == 20) {
            this.tick = 0;
            this.updateWorkOrders();
        }
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(this.buildingView.getColony().getWorkOrders());
        if (this.manualMode) {
            this.workOrders.removeIf(order -> !order.getClaimedBy().equals((Object)this.buildingView.getPosition()) && !order.getClaimedBy().equals((Object)BlockPos.f_121853_));
        } else {
            this.workOrders.removeIf(order -> !order.getClaimedBy().equals((Object)this.buildingView.getPosition()));
        }
        this.workOrders.removeIf(order -> !order.canBuildIngoringDistance(this.buildingView.getPosition(), this.buildingView.getBuildingLevel()));
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(WorkOrderView::getPriority, Comparator.reverseOrder()));
    }

    private void updateAvailableWorkOrders(int index, @NotNull Pane rowPane) {
        WorkOrderView order = this.workOrders.get(index);
        ((Text)rowPane.findPaneOfTypeByID("buildingName", Text.class)).setText(order.getDisplayName());
        ((Text)rowPane.findPaneOfTypeByID("buildingPos", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.blocks.distance", new Object[]{BlockPosUtil.getDistance2D(order.getPos(), this.buildingView.getPosition())}));
        if (order.getClaimedBy().equals((Object)this.buildingView.getPosition())) {
            ((ButtonImage)rowPane.findPaneOfTypeByID("manage", ButtonImage.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.builder.cancel"));
        } else if (this.manualMode) {
            ((ButtonImage)rowPane.findPaneOfTypeByID("manage", ButtonImage.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.builder.select"));
        }
    }

    private void selectWorkOrder(@NotNull Button button) {
        int row = this.workOrdersList.getListElementIndexByPane((Pane)button);
        WorkOrderView view = this.workOrders.get(row);
        if (view.getClaimedBy().equals((Object)this.buildingView.getPosition())) {
            view.setClaimedBy(this.buildingView.getPosition());
            Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.buildingView, view.getId(), true, 0));
        } else {
            Network.getNetwork().sendToServer(new BuilderSelectWorkOrderMessage(this.buildingView, view.getId()));
        }
    }
}

