/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class WindowHappinessPage
extends AbstractWindowTownHall {
    public WindowHappinessPage(BuildingTownHall.View townHall) {
        super(townHall, "layouthappiness.xml");
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateHappiness();
    }

    private void updateHappiness() {
        HashMap<String, Double> happinessMap = new HashMap<String, Double>();
        for (ICitizenDataView data : ((ITownHallView)this.building).getColony().getCitizens().values()) {
            for (String string : data.getHappinessHandler().getModifiers()) {
                happinessMap.put(string, happinessMap.getOrDefault(string, 0.0) + data.getHappinessHandler().getModifier(string).getFactor());
            }
        }
        View pane = (View)this.findPaneOfTypeByID("happinesspage", View.class);
        int yPos = 62;
        for (Map.Entry entry : happinessMap.entrySet()) {
            double value = (Double)entry.getValue() / (double)((ITownHallView)this.building).getColony().getCitizenCount();
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(0, yPos);
            Text label = new Text();
            label.setSize(136, 11);
            label.setPosition(25, yPos);
            label.setColors(WindowBuilderResModule.BLACK);
            label.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.happiness." + (String)entry.getKey()));
            if (value > 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/green_icon.png"), false);
            } else if (value == 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/blue_icon.png"), false);
            } else if (value > 0.75) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/yellow_icon.png"), false);
            } else {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/red_icon.png"), false);
            }
            pane.addChild((Pane)image);
            pane.addChild((Pane)label);
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)label).append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.happiness.desc." + (String)entry.getKey()))).build();
            yPos += 12;
        }
    }

    @Override
    protected String getWindowId() {
        return "happiness";
    }
}

