/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallMercenary;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.commands.ClickEventWithExecutable;
import com.minecolonies.coremod.network.messages.server.colony.TeleportToColonyMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class WindowMainPage
extends AbstractWindowTownHall {
    private final ScrollingList alliesList = (ScrollingList)this.findPaneOfTypeByID("allies", ScrollingList.class);
    private final ScrollingList feudsList = (ScrollingList)this.findPaneOfTypeByID("feuds", ScrollingList.class);

    public WindowMainPage(BuildingTownHall.View building) {
        super(building, "layoutactions.xml");
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("mercenaries", this::mercenaryClicked);
        this.registerButton("tp", this::teleportToColony);
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane((Pane)button);
        CompactColonyReference ally = ((ITownHallView)this.building).getColony().getAllies().get(row);
        MutableComponent teleport = new TranslatableComponent("com.minecolonies.coremod.gui.townhall.tp", new Object[]{ally.name}).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GOLD).m_131142_((ClickEvent)new ClickEventWithExecutable(ClickEvent.Action.RUN_COMMAND, "", () -> Network.getNetwork().sendToServer(new TeleportToColonyMessage(ally.dimension, ally.id)))));
        Minecraft.m_91087_().f_91074_.m_6352_((Component)teleport, Minecraft.m_91087_().f_91074_.m_142081_());
        this.close();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillAlliesAndFeudsList();
        if (((ITownHallView)this.building).getColony().getMercenaryUseTime() != 0L && ((ITownHallView)this.building).getColony().getWorld().m_46467_() - ((ITownHallView)this.building).getColony().getMercenaryUseTime() < 48000L) {
            ((Button)this.findPaneOfTypeByID("mercenaries", Button.class)).disable();
        }
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getAllies().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowMainPage.this.building).getColony().getAllies().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(colonyReference.name);
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowMainPage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText((int)distance + "b");
                Button button = (Button)rowPane.findPaneOfTypeByID("tp", Button.class);
                if (colonyReference.hasTownHall && (((ITownHallView)WindowMainPage.this.building).getBuildingLevel() < (Integer)MineColonies.getConfig().getServer().minThLevelToTeleport.get() || !((ITownHallView)WindowMainPage.this.building).canPlayerUseTP())) {
                    button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.tooLow"));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getFeuds().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowMainPage.this.building).getColony().getFeuds().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(colonyReference.name);
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowMainPage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(String.valueOf((int)distance));
            }
        });
    }

    private void renameClicked() {
        @NotNull WindowTownHallNameEntry window = new WindowTownHallNameEntry(((ITownHallView)this.building).getColony());
        window.open();
    }

    private void mercenaryClicked() {
        @NotNull WindowTownHallMercenary window = new WindowTownHallMercenary(((ITownHallView)this.building).getColony());
        window.open();
    }

    @Override
    protected String getWindowId() {
        return "actions";
    }
}

