/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class LivingBuildingModule
extends AbstractAssignedCitizenModule
implements IAssignsCitizen,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void deserializeNBT(CompoundTag compound) {
        block3: {
            int[] residentIds;
            block2: {
                int[] residentIds2;
                super.deserializeNBT(compound);
                if (!compound.m_128441_("residents")) break block2;
                for (int citizenId : residentIds2 = compound.m_128465_("residents")) {
                    ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                    if (citizen == null) continue;
                    this.assignCitizen(citizen);
                }
                break block3;
            }
            if (!compound.m_128441_("residents")) break block3;
            for (int citizenId : residentIds = compound.m_128465_("residents")) {
                ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        super.serializeNBT(compound);
        if (!this.assignedCitizen.isEmpty()) {
            @NotNull int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            compound.m_128385_("residents", residentIds);
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && !this.building.getColony().isManualHousing()) {
            for (ICitizenData citizen : this.building.getColony().getCitizenManager().getCitizens()) {
                if (this.isFull()) break;
                if (citizen.getHomeBuilding() != null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    void onAssignment(ICitizenData citizen) {
        citizen.setHomeBuilding(this.building);
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        citizen.setHomeBuilding(null);
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public int getModuleMax() {
        return this.building.getBuildingLevel();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }
}

