/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLevelManagementModule
extends AbstractBuildingModule
implements IPersistentModule {
    @NotNull
    private final List<MinerLevel> levels = new ArrayList<MinerLevel>();
    private int currentLevel = 0;
    @Nullable
    private Node activeNode = null;
    @Nullable
    private Node oldNode = null;
    private int startingLevelShaft = 0;

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.startingLevelShaft = compound.m_128451_("newStartingLevelShaft");
        this.currentLevel = compound.m_128451_("currentLevel");
        ListTag levelTagList = compound.m_128437_("levels", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            this.levels.add(new MinerLevel(levelTagList.m_128728_(i)));
        }
        if (compound.m_128431_().contains("activeNodeNode")) {
            this.activeNode = Node.createFromNBT(compound.m_128469_("activeNodeNode"));
        } else if (compound.m_128431_().contains("oldNodeNode")) {
            this.oldNode = Node.createFromNBT(compound.m_128469_("oldNodeNode"));
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        CompoundTag nodeCompound;
        compound.m_128405_("newStartingLevelShaft", this.startingLevelShaft);
        compound.m_128405_("currentLevel", this.currentLevel);
        @NotNull ListTag levelTagList = new ListTag();
        for (MinerLevel level : this.levels) {
            @NotNull CompoundTag levelCompound = new CompoundTag();
            level.write(levelCompound);
            levelTagList.add((Object)levelCompound);
        }
        compound.m_128365_("levels", (Tag)levelTagList);
        if (this.activeNode != null) {
            nodeCompound = new CompoundTag();
            this.activeNode.write(nodeCompound);
            compound.m_128365_("activeNodeNode", (Tag)nodeCompound);
        }
        if (this.oldNode != null) {
            nodeCompound = new CompoundTag();
            this.oldNode.write(nodeCompound);
            compound.m_128365_("oldNodeNode", (Tag)nodeCompound);
        }
    }

    @Override
    public void serializeToView(FriendlyByteBuf buf) {
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (MinerLevel level : this.levels) {
            buf.writeInt(level.getNumberOfBuiltNodes());
            buf.writeInt(level.getDepth());
        }
        List<WorkOrderBuildMiner> list = this.building.getColony().getWorkManager().getOrderedList(WorkOrderBuildMiner.class, this.building.getPosition());
        buf.writeInt(list.size());
        for (WorkOrderBuildMiner wo : list) {
            wo.serializeViewNetworkData(buf);
        }
    }

    public void addLevel(MinerLevel currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public MinerLevel getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public int getLevelId(MinerLevel level) {
        return this.levels.indexOf(level);
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
        this.activeNode = null;
        this.oldNode = null;
    }

    public int getStartingLevelShaft() {
        if (this.levels.isEmpty()) {
            return this.startingLevelShaft;
        }
        return this.levels.get(this.levels.size() - 1).getDepth() - 6;
    }

    @NotNull
    public Node getActiveNode() {
        Node calcNode;
        Node node = calcNode = this.activeNode == null || this.activeNode.getStatus() == Node.NodeStatus.COMPLETED ? this.levels.get(this.currentLevel).getRandomNode(this.oldNode) : this.activeNode;
        if (this.activeNode != calcNode) {
            this.activeNode = calcNode;
        }
        return this.activeNode;
    }

    public void setActiveNode(@Nullable Node activeNode) {
        this.activeNode = activeNode;
    }

    public void setOldNode(@Nullable Node oldNode) {
        this.oldNode = oldNode;
    }

    public void setStartingLevelShaft(int level) {
        this.startingLevelShaft = level;
    }

    public void repairLevel(int level) {
        if (this.building instanceof BuildingMiner) {
            BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
            BlockPos vector = ladderPos.m_141950_((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
            int xOffset = 3 * vector.m_123341_();
            int zOffset = 3 * vector.m_123343_();
            BuildingMiner.initStructure(null, 0, new BlockPos(ladderPos.m_123341_() + xOffset, this.levels.get(level).getDepth(), ladderPos.m_123343_() + zOffset), (BuildingMiner)this.building, this.building.getColony().getWorld(), null);
        }
    }

    public List<MinerLevel> getLevels() {
        return this.levels;
    }
}

