/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlantationSetting
extends StringSetting {
    private boolean hasResearch;

    public PlantationSetting(String ... settings) {
        super(settings);
    }

    public PlantationSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        this.hasResearch = building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0;
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("minecolonies:gui/layouthuts/layoutstringsetting.xml"), (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        if (this.hasResearch) {
            ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText(this.getCombinedSetting());
        } else {
            ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((MutableComponent)new TranslatableComponent(this.getSettings().get(this.getCurrentIndex())));
        }
    }

    private MutableComponent getCombinedSetting() {
        TranslatableComponent component = new TranslatableComponent("");
        for (int i = 0; i < this.getSettings().size(); ++i) {
            if (i == this.getCurrentIndex()) continue;
            if (!component.m_7360_().isEmpty()) {
                component.m_7220_((Component)new TextComponent(" & "));
            }
            component.m_7220_((Component)new TranslatableComponent(this.getSettings().get(i)));
        }
        return component;
    }
}

