/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class LivingBuildingView
extends AbstractBuildingView {
    @NotNull
    private final List<Integer> residents = new ArrayList<Integer>();

    public LivingBuildingView(IColonyView c, BlockPos l) {
        super(c, l);
    }

    @NotNull
    public List<Integer> getResidents() {
        return Collections.unmodifiableList(this.residents);
    }

    public void removeResident(int index) {
        this.residents.remove(index);
    }

    public void addResident(int id) {
        this.residents.add(id);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.residents.clear();
        int numResidents = buf.readInt();
        for (int i = 0; i < numResidents; ++i) {
            this.residents.add(buf.readInt());
        }
    }
}

