/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class BuildingBaker
extends AbstractBuilding {
    private static final String BAKER = "baker";
    private static final int BAKER_HUT_MAX_LEVEL = 5;

    public BuildingBaker(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BAKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    protected boolean keepFood() {
        return false;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42405_) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingBaker.BAKER).orElse(false);
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            if (this.building == null) {
                return true;
            }
            return this.building.getBuildingLevel() >= 3;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        private static final int RECIPE_INPUT_HOLD = 128;

        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingBaker.BAKER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingBaker.BAKER);
            return isRecipeAllowed.orElse(false);
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            if (this.building == null) {
                return true;
            }
            return this.building.getBuildingLevel() >= 3;
        }

        @Override
        public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
            Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> map = super.getRequiredItemsAndAmount();
            for (IToken<?> token : this.getRecipes()) {
                IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                for (ItemStorage itemStorage : storage.getCleanedInput()) {
                    ItemStack stack = itemStorage.getItemStack();
                    map.put(arg_0 -> ((ItemStack)stack).m_41656_(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)128, (Object)false));
                }
            }
            return map;
        }
    }
}

