/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import org.jetbrains.annotations.NotNull;

public class BuildingMechanic
extends AbstractBuilding {
    private static final String MECHANIC = "mechanic";

    public BuildingMechanic(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MECHANIC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            ItemStack stack = recipe.getPrimaryOutput().m_41777_();
            if (stack.m_41720_().getRegistryName().m_135827_().equals("domum_ornamentum")) {
                CompoundTag dataNbt = stack.m_41698_("textureData");
                MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT((CompoundTag)dataNbt);
                for (Block block : textureData.getTexturedComponents().values()) {
                    ItemStack ingredientStack = new ItemStack((ItemLike)block);
                    if (ItemStackUtils.isEmpty(ingredientStack).booleanValue() || ModTags.crafterIngredient.get("fletcher").m_8110_((Object)ingredientStack.m_41720_()) || ModTags.crafterIngredient.get("sawmill").m_8110_((Object)ingredientStack.m_41720_()) || ModTags.crafterIngredient.get("stonemason").m_8110_((Object)ingredientStack.m_41720_()) || ModTags.crafterIngredient.get("glassblower").m_8110_((Object)ingredientStack.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            return true;
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            return false;
        }

        @Override
        public boolean canLearnLargeRecipes() {
            return true;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingMechanic.MECHANIC).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingMechanic.MECHANIC);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            Item item = recipe.getPrimaryOutput().m_41720_();
            return item instanceof MinecartItem || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof HopperBlock;
        }
    }
}

