/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.PlantationSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingPlantation
extends AbstractBuilding {
    public static final ISettingKey<PlantationSetting> MODE = new SettingKey<PlantationSetting>(PlantationSetting.class, new ResourceLocation("minecolonies", "mode"));
    private static final String PLANTATION = "plantation";
    private final List<BlockPos> sand = new ArrayList<BlockPos>();
    private Item currentPhase = Items.f_41909_;
    private final List<Item> settings = Arrays.asList(Items.f_41909_, Items.f_41982_, Items.f_41911_);

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        Block down;
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.f_49992_ && ((down = world.m_8055_(pos.m_7495_()).m_60734_()) == Blocks.f_50652_ || down == Blocks.f_50222_)) {
            this.sand.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag sandPos = compound.m_128437_("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.sand.add(NbtUtils.m_129239_((CompoundTag)sandPos.m_128728_(i).m_128469_("pos")));
        }
        this.currentPhase = ItemStack.m_41712_((CompoundTag)compound.m_128469_("currentPhase")).m_41720_();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag sandCompoundList = new ListTag();
        for (BlockPos entry : this.sand) {
            @NotNull CompoundTag sandCompound = new CompoundTag();
            sandCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.m_128365_("plantGround", (Tag)sandCompoundList);
        compound.m_128365_("currentPhase", (Tag)new ItemStack((ItemLike)this.currentPhase).m_41739_(new CompoundTag()));
        return compound;
    }

    public List<BlockPos> getPosForPhase() {
        ArrayList<BlockPos> filtered = new ArrayList<BlockPos>();
        if (this.tileEntity != null && !this.tileEntity.getPositionedTags().isEmpty()) {
            Item phase = this.nextPlantPhase();
            for (Map.Entry<BlockPos, List<String>> entry : this.tileEntity.getPositionedTags().entrySet()) {
                if (!(entry.getValue().contains("bamboo") && phase == Items.f_41911_ || entry.getValue().contains("sugar") && phase == Items.f_41909_) && (!entry.getValue().contains("cactus") || phase != Items.f_41982_)) continue;
                filtered.add(this.getPosition().m_141952_((Vec3i)entry.getKey()));
            }
        }
        return filtered;
    }

    public Item nextPlantPhase() {
        if (this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0) {
            int next = this.settings.indexOf(this.currentPhase);
            while (this.settings.get(next = (next + 1) % this.settings.size()) == this.getSetting()) {
            }
            this.currentPhase = this.settings.get(next);
            return this.currentPhase;
        }
        return this.getSetting();
    }

    private Item getSetting() {
        String setting = this.getSetting(MODE).getValue();
        if (setting.equals(Items.f_41909_.m_5524_())) {
            return Items.f_41909_;
        }
        if (setting.equals(Items.f_41982_.m_5524_())) {
            return Items.f_41982_;
        }
        if (setting.equals(Items.f_41911_.m_5524_())) {
            return Items.f_41911_;
        }
        return Items.f_41909_;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingPlantation.PLANTATION).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingPlantation.PLANTATION);
            return isRecipeAllowed.orElse(false);
        }
    }
}

