/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingUniversity
extends AbstractBuilding {
    private static final String UNIVERSITY = "university";
    private static final int OFFLINE_PROCESSING_LEVEL_CAP = 3;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingUniversity(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return UNIVERSITY;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag furnaceTagList = compound.m_128437_("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag bookcaseTagList = new ListTag();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundTag bookCompound = new CompoundTag();
            bookCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.m_128365_("bookcase", (Tag)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.f_50078_) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().m_8055_(returnPos).m_60734_() == Blocks.f_50078_) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        List<ILocalResearch> inProgress = colony.getResearchManager().getResearchTree().getResearchInProgress();
        WorkerBuildingModule module = this.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == ModJobs.researcher);
        int i = 1;
        for (ILocalResearch research : inProgress) {
            if (i > module.getAssignedCitizen().size()) {
                return;
            }
            for (ICitizenData data : this.getAllAssignedCitizen()) {
                data.getCitizenSkillHandler().addXpToSkill(module.getSecondarySkill(), 25.0, data);
            }
            if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).research(colony.getResearchManager().getResearchEffects(), colony.getResearchManager().getResearchTree())) {
                this.onSuccess(research);
            }
            ++i;
        }
    }

    public void onSuccess(ILocalResearch research) {
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.applyResearchEffects();
        }
        TranslatableComponent message = new TranslatableComponent("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3), new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()});
        for (Player player : this.colony.getMessagePlayerEntities()) {
            player.m_6352_((Component)message, player.m_142081_());
        }
        this.colony.getResearchManager().checkAutoStartResearch();
        this.markDirty();
    }

    @Override
    public void processOfflineTime(long time) {
        if (this.getBuildingLevel() >= 3 && time > 0L) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.researcher.moreknowledge", (Object[])new Object[0]);
            for (ICitizenData citizenData : this.getAllAssignedCitizen()) {
                if (citizenData.getJob() == null) continue;
                citizenData.getJob().processOfflineTime(time);
            }
        }
    }
}

