/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.util.Log;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LootTableAnalyzer {
    private LootTableAnalyzer() {
    }

    public static List<LootDrop> toDrops(@NotNull LootTables lootTableManager, @NotNull ResourceLocation lootTableId) {
        return LootTableAnalyzer.toDrops(lootTableManager, lootTableManager.m_79217_(lootTableId));
    }

    public static List<LootDrop> toDrops(@Nullable LootTables lootTableManager, @NotNull LootTable lootTable) {
        try {
            JsonObject lootTableJson = LootTables.m_79200_((LootTable)lootTable).getAsJsonObject();
            return LootTableAnalyzer.toDrops(lootTableManager, lootTableJson);
        }
        catch (JsonParseException ex) {
            Log.getLogger().error(String.format("Failed to parse loot table from %s", lootTable.getLootTableId()), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static List<LootDrop> toDrops(@Nullable LootTables lootTableManager, @NotNull JsonObject lootTableJson) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        if (!lootTableJson.has("pools")) {
            return drops;
        }
        JsonArray pools = GsonHelper.m_13933_((JsonObject)lootTableJson, (String)"pools");
        for (JsonElement pool : pools) {
            JsonArray entries = GsonHelper.m_13832_((JsonObject)pool.getAsJsonObject(), (String)"entries", (JsonArray)new JsonArray());
            float totalWeight = StreamSupport.stream(entries.spliterator(), false).filter(entry -> {
                String type = GsonHelper.m_13906_((JsonObject)entry.getAsJsonObject(), (String)"type");
                return type.equals("minecraft:empty") || type.equals("minecraft:item") || type.equals("minecraft:tag") || type.equals("minecraft:loot_table");
            }).mapToInt(entry -> GsonHelper.m_13824_((JsonObject)entry.getAsJsonObject(), (String)"weight", (int)1)).sum();
            for (JsonElement ej : entries) {
                boolean conditional;
                JsonObject entryJson = ej.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)entryJson, (String)"type");
                if (type.equals("minecraft:item")) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)entryJson, (String)"name")));
                    float weight = GsonHelper.m_13820_((JsonObject)entryJson, (String)"weight", (float)1.0f);
                    float quality = GsonHelper.m_13820_((JsonObject)entryJson, (String)"quality", (float)0.0f);
                    float modifier = 1.0f;
                    conditional = GsonHelper.m_13832_((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray()).size() > 0;
                    ItemStack stack = new ItemStack((ItemLike)item);
                    if (entryJson.has("functions")) {
                        Tuple<ItemStack, Float> result = LootTableAnalyzer.processFunctions(stack, GsonHelper.m_13933_((JsonObject)entryJson, (String)"functions"));
                        stack = (ItemStack)result.m_14418_();
                        modifier = ((Float)result.m_14419_()).floatValue();
                    }
                    drops.add(new LootDrop(Collections.singletonList(stack), weight / totalWeight * modifier, quality, conditional));
                    continue;
                }
                if (!type.equals("minecraft:loot_table") || lootTableManager == null) continue;
                ResourceLocation table = new ResourceLocation(GsonHelper.m_13906_((JsonObject)entryJson, (String)"name"));
                List<LootDrop> tableDrops = LootTableAnalyzer.toDrops(lootTableManager, table);
                float weight = GsonHelper.m_13820_((JsonObject)entryJson, (String)"weight", (float)1.0f);
                float quality = GsonHelper.m_13820_((JsonObject)entryJson, (String)"quality", (float)0.0f);
                conditional = GsonHelper.m_13832_((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray()).size() > 0;
                for (LootDrop drop : tableDrops) {
                    drops.add(new LootDrop(drop.getItemStacks(), drop.getProbability() * (weight / totalWeight), drop.getQuality() + quality, drop.getConditional() || conditional));
                }
            }
        }
        drops.sort(Comparator.comparing(LootDrop::getProbability).reversed());
        return drops;
    }

    @NotNull
    public static List<LootDrop> consolidate(@NotNull List<LootDrop> input) {
        return input.stream().collect(Collectors.groupingBy(LootDrop::hashCode)).values().stream().map(LootDrop::new).sorted(Comparator.comparing(LootDrop::getProbability).reversed()).collect(Collectors.toList());
    }

    private static Tuple<ItemStack, Float> processFunctions(@NotNull ItemStack stack, @NotNull JsonArray functions) {
        float modifier = 1.0f;
        block18: for (JsonElement je : functions) {
            String name;
            JsonObject function = je.getAsJsonObject();
            switch (name = GsonHelper.m_13851_((JsonObject)function, (String)"function", (String)"")) {
                case "minecraft:set_count": {
                    Tuple<Integer, Float> result = LootTableAnalyzer.processCount(function.get("count"));
                    stack.m_41764_(((Integer)result.m_14418_()).intValue());
                    modifier *= ((Float)result.m_14419_()).floatValue();
                    continue block18;
                }
                case "minecraft:set_damage": {
                    if (!stack.m_41763_()) continue block18;
                    float damage = 1.0f - LootTableAnalyzer.processNumber(function.get("damage"), 0.0f);
                    stack.m_41721_(Mth.m_14143_((float)(damage * (float)stack.m_41776_())));
                    continue block18;
                }
                case "minecraft:set_nbt": {
                    try {
                        stack.m_41751_(TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)function, (String)"tag")));
                    }
                    catch (CommandSyntaxException e) {
                        Log.getLogger().error("Failed to parse set_nbt in loot table", (Throwable)e);
                    }
                    continue block18;
                }
                case "minecraft:enchant_with_levels": {
                    int levels = LootTableAnalyzer.processNumber(function.get("levels"), 1);
                    boolean treasure = GsonHelper.m_13855_((JsonObject)function, (String)"treasure", (boolean)false);
                    stack = EnchantmentHelper.m_44877_((Random)ThreadLocalRandom.current(), (ItemStack)stack, (int)levels, (boolean)treasure);
                    continue block18;
                }
                case "minecraft:looting_enchant": {
                    continue block18;
                }
                case "minecraft:furnace_smelt": {
                    continue block18;
                }
            }
            Log.getLogger().warn("Unhandled modifier in loot table: " + name);
        }
        return new Tuple((Object)stack, (Object)Float.valueOf(modifier));
    }

    private static Tuple<Integer, Float> processCount(@Nullable JsonElement json) {
        if (json == null) {
            return new Tuple((Object)1, (Object)Float.valueOf(1.0f));
        }
        if (json.isJsonObject() && GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"type", (String)"").equals("uniform")) {
            int min = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"min", (int)0);
            int max = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"max", (int)1);
            return new Tuple((Object)max, (Object)Float.valueOf(min == 0 ? (float)max / ((float)max + 1.0f) : 1.0f));
        }
        return new Tuple((Object)LootTableAnalyzer.processNumber(json, 1), (Object)Float.valueOf(1.0f));
    }

    private static int processNumber(@Nullable JsonElement json, int defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        if (json.isJsonObject()) {
            switch (GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"type", (String)"")) {
                case "constant": {
                    return GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"value", (int)defaultValue);
                }
                case "uniform": {
                    return GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"max", (int)defaultValue);
                }
            }
            return defaultValue;
        }
        if (json.isJsonPrimitive()) {
            return json.getAsJsonPrimitive().getAsInt();
        }
        return defaultValue;
    }

    private static float processNumber(@Nullable JsonElement json, float defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        if (json.isJsonObject()) {
            switch (GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"type", (String)"")) {
                case "constant": {
                    return GsonHelper.m_13820_((JsonObject)json.getAsJsonObject(), (String)"value", (float)defaultValue);
                }
                case "uniform": {
                    return GsonHelper.m_13820_((JsonObject)json.getAsJsonObject(), (String)"max", (float)defaultValue);
                }
            }
            return defaultValue;
        }
        if (json.isJsonPrimitive()) {
            return json.getAsJsonPrimitive().getAsFloat();
        }
        return defaultValue;
    }

    public static class LootDrop {
        private final List<ItemStack> stacks;
        private final float probability;
        private final float quality;
        private final boolean conditional;

        public LootDrop(@NotNull List<ItemStack> stacks, float probability, float quality, boolean conditional) {
            this.stacks = stacks;
            this.probability = probability;
            this.quality = quality;
            this.conditional = conditional;
        }

        public LootDrop(@NotNull List<LootDrop> drops) {
            this.stacks = drops.stream().flatMap(d -> d.getItemStacks().stream()).collect(Collectors.toList());
            this.probability = drops.get(0).getProbability();
            this.quality = drops.get(0).getQuality();
            this.conditional = drops.get(0).getConditional();
        }

        @NotNull
        public List<ItemStack> getItemStacks() {
            return this.stacks;
        }

        public float getProbability() {
            return this.probability;
        }

        public float getQuality() {
            return this.quality;
        }

        public boolean getConditional() {
            return this.conditional;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.probability), Float.valueOf(this.quality), this.conditional);
        }

        public void serialize(@NotNull FriendlyByteBuf buffer) {
            buffer.m_130130_(this.stacks.size());
            for (ItemStack stack : this.stacks) {
                buffer.m_130055_(stack);
            }
            buffer.writeFloat(this.probability);
            buffer.writeFloat(this.quality);
            buffer.writeBoolean(this.conditional);
        }

        public static LootDrop deserialize(@NotNull FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
            for (int i = 0; i < size; ++i) {
                stacks.add(buffer.m_130267_());
            }
            float probability = buffer.readFloat();
            float quality = buffer.readFloat();
            boolean conditional = buffer.readBoolean();
            return new LootDrop(stacks, probability, quality, conditional);
        }
    }
}

