/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class PosBasedInteraction
extends ServerCitizenInteraction {
    private static final String POS_TAG = "pos";
    private static final Tuple<Component, Component>[] responses = new Tuple[]{new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.okay"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.ignore"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.remindmelater"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.skipchitchat"), null)};
    private BlockPos pos = null;
    private BiPredicate<ICitizenData, BlockPos> validator;

    public PosBasedInteraction(Component inquiry, IChatPriority priority, Component validator, BlockPos pos) {
        super(inquiry, true, priority, null, validator, responses);
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(validator);
        this.pos = pos;
    }

    public PosBasedInteraction(Component inquiry, IChatPriority priority, BlockPos pos) {
        super(inquiry, true, priority, null, inquiry, responses);
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(inquiry);
        this.pos = pos;
    }

    public PosBasedInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        if (this.pos != null && !WorldUtil.isBlockLoaded((LevelAccessor)citizen.getColony().getWorld(), this.pos)) {
            return true;
        }
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.pos);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        BlockPosUtil.writeToNBT((CompoundTag)tag, (String)POS_TAG, (BlockPos)this.pos);
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.pos = BlockPosUtil.readFromNBT((CompoundTag)compoundNBT, (String)POS_TAG);
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getPosBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.POS.m_135815_();
    }
}

