/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RecruitmentInteraction
extends ServerCitizenInteraction {
    private static final String RECRUITMENT_ICON = "recruitIcon";
    private static final ResourceLocation icon = new ResourceLocation("minecolonies", "textures/icons/recruiticon.png");
    private static final Tuple<Component, Component> recruitAnswer = new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.recruit"), null);
    private static final Tuple<Component, Component>[] responses = new Tuple[]{new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.showstats"), null), recruitAnswer, new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.notnow"), null)};

    public RecruitmentInteraction(ICitizen data) {
        super(data);
    }

    public RecruitmentInteraction(Component inquiry, IChatPriority priority) {
        super(inquiry, true, priority, (ICitizenData d) -> true, null, responses);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.RECRUITMENT.m_135815_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(BOWindow window, ICitizenDataView dataView) {
        ButtonImage recruitButton = (ButtonImage)window.findPaneOfTypeByID("response_2", ButtonImage.class);
        Box group = (Box)window.findPaneOfTypeByID("responseOptions", Box.class);
        if (recruitButton != null && dataView instanceof IVisitorViewData) {
            ItemStack recruitCost = ((IVisitorViewData)dataView).getRecruitCost();
            IColonyView colony = ((IVisitorViewData)dataView).getColonyView();
            ((Text)window.findPaneOfTypeByID("chat", Text.class)).setText(((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().append((MutableComponent)new TextComponent(dataView.getName() + ": "))).append(this.getInquiry())).emptyLines(1)).append((MutableComponent)new TranslatableComponent(colony.getCitizens().size() < colony.getCitizenCountLimit() ? "com.minecolonies.coremod.gui.chat.recruitcost" : "com.minecolonies.coremod.gui.chat.nospacerecruit", new Object[]{dataView.getName().split(" ")[0], recruitCost.m_41613_() + " " + recruitCost.m_41786_().getString()}))).getText());
            int iconPosX = recruitButton.getX() + recruitButton.getWidth() - 28;
            int iconPosY = recruitButton.getY() + recruitButton.getHeight() - 18;
            ItemIcon icon = new ItemIcon();
            icon.setID(RECRUITMENT_ICON);
            icon.setSize(15, 15);
            group.addChild((Pane)icon);
            icon.setItem(((IVisitorViewData)dataView).getRecruitCost());
            icon.setPosition(iconPosX, iconPosY);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(Component response, Player player, ICitizenDataView data, BOWindow window) {
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorViewData) {
            if (player.m_7500_() || InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), ((IVisitorViewData)data).getRecruitCost().m_41720_()) >= ((IVisitorViewData)data).getRecruitCost().m_41613_()) {
                return super.onClientResponseTriggered(response, player, data, window);
            }
            LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.gui.chat.notenoughitems", (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(Component response, Player player, ICitizenData data) {
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorData) {
            IColony colony = data.getColony();
            if (colony.getCitizenManager().getCurrentCitizenCount() < colony.getCitizenManager().getPotentialMaxCitizens()) {
                if (player.m_7500_() || InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), ((IVisitorData)data).getRecruitCost(), ((IVisitorData)data).getRecruitCost().m_41613_(), true, true)) {
                    colony.getVisitorManager().removeCivilian(data);
                    data.setWorkBuilding(null);
                    data.setHomeBuilding(null);
                    data.setJob(null);
                    if (colony.getWorld().f_46441_.nextInt(100) <= (Integer)MineColonies.getConfig().getServer().badVisitorsChance.get()) {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.runaway", (Object[])new Object[]{data.getName()});
                        return;
                    }
                    ICitizenData newCitizen = colony.getCitizenManager().createAndRegisterCivilianData();
                    newCitizen.deserializeNBT((Tag)((CompoundTag)data.serializeNBT()));
                    newCitizen.setParents("", "");
                    newCitizen.updateEntityIfNecessary();
                    data.getEntity().ifPresent(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
                    if (data.hasCustomTexture()) {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.message.custom", (Object[])new Object[]{data.getName()});
                    } else {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.message", (Object[])new Object[]{data.getName()});
                    }
                }
            } else {
                LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.gui.chat.nospace", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        return icon;
    }
}

