/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.huts.BlockHutTavern;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.BuildingMysticalSite;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingManager
implements IBuildingManager {
    @NotNull
    private ImmutableMap<BlockPos, IBuilding> buildings = ImmutableMap.of();
    private final List<BlockPos> fields = new ArrayList<BlockPos>();
    private final List<IWareHouse> wareHouses = new ArrayList<IWareHouse>();
    private final List<IMysticalSite> mysticalSites = new ArrayList<IMysticalSite>();
    @Nullable
    private ITownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isFieldsDirty = false;
    private final Colony colony;
    private int minChunkX;
    private int maxChunkX;
    private int minChunkZ;
    private int maxChunkZ;

    public BuildingManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.buildings = ImmutableMap.of();
        this.maxChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.minChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.maxChunkZ = this.colony.getCenter().m_123343_() >> 4;
        this.minChunkZ = this.colony.getCenter().m_123343_() >> 4;
        ListTag buildingTagList = compound.m_128437_("buildings", 10);
        for (int i = 0; i < buildingTagList.size(); ++i) {
            CompoundTag buildingCompound = buildingTagList.m_128728_(i);
            @Nullable IBuilding b = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
            this.setMaxChunk(b);
        }
        if (compound.m_128431_().contains("newFields")) {
            ListTag fieldTagList = compound.m_128437_("newFields", 10);
            for (int i = 0; i < fieldTagList.size(); ++i) {
                this.addField(BlockPosUtil.read(fieldTagList.m_128728_(i), "pos"));
            }
        }
    }

    private void setMaxChunk(IBuilding b) {
        int chunkX = b.getPosition().m_123341_() >> 4;
        int chunkZ = b.getPosition().m_123343_() >> 4;
        if (chunkX >= this.maxChunkX) {
            this.maxChunkX = chunkX + 1;
        }
        if (chunkX <= this.minChunkX) {
            this.minChunkX = chunkX - 1;
        }
        if (chunkZ >= this.maxChunkZ) {
            this.maxChunkZ = chunkZ + 1;
        }
        if (chunkZ <= this.minChunkZ) {
            this.minChunkZ = chunkZ - 1;
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag buildingTagList = new ListTag();
        for (IBuilding b : this.buildings.values()) {
            @NotNull CompoundTag buildingCompound = b.serializeNBT();
            buildingTagList.add((Object)buildingCompound);
        }
        compound.m_128365_("buildings", (Tag)buildingTagList);
        @NotNull ListTag fieldTagList = new ListTag();
        for (BlockPos pos : this.fields) {
            @NotNull CompoundTag fieldCompound = new CompoundTag();
            BlockPosUtil.write(fieldCompound, "pos", pos);
            fieldTagList.add((Object)fieldCompound);
        }
        compound.m_128365_("newFields", (Tag)fieldTagList);
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.buildings.values().forEach(ISchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        this.sendBuildingPackets(closeSubscribers, newSubscribers);
        this.sendFieldPackets(closeSubscribers, newSubscribers);
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        for (IBuilding building : this.buildings.values()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), building.getPosition())) continue;
            building.onColonyTick(colony);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull IColony colony) {
        @Nullable ArrayList<IBuilding> removedBuildings = new ArrayList<IBuilding>();
        ArrayList tempBuildings = new ArrayList(this.buildings.values());
        for (IBuilding building : tempBuildings) {
            BlockPos loc = building.getPosition();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), loc) || building.isMatchingBlock(colony.getWorld().m_8055_(loc).m_60734_())) continue;
            removedBuildings.add(building);
        }
        @NotNull ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.fields);
        for (BlockPos pos : tempFields) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), pos)) continue;
            if (colony.getWorld().m_7702_(pos) instanceof ScarecrowTileEntity) {
                ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)colony.getWorld().m_7702_(pos);
                if (scarecrow != null) continue;
                this.removeField(pos);
                continue;
            }
            this.removeField(pos);
        }
        if (!removedBuildings.isEmpty() && removedBuildings.size() >= this.buildings.values().size()) {
            Log.getLogger().warn("Colony:" + colony.getID() + " is removing all buildings at once. Did you just load a backup? If not there is a chance that colony data got corrupted and you want to restore a backup.");
        }
        removedBuildings.forEach(IBuilding::destroy);
    }

    @Override
    public IBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return (IBuilding)this.buildings.get((Object)buildingId);
        }
        return null;
    }

    @Override
    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos pos) {
        IWareHouse wareHouse = null;
        double dist = 0.0;
        for (IWareHouse building : this.wareHouses) {
            if (building.getBuildingLevel() <= 0 || building.getTileEntity() == null) continue;
            double tempDist = building.getPosition().m_123331_((Vec3i)pos);
            if (wareHouse != null && !(tempDist < dist)) continue;
            dist = tempDist;
            wareHouse = building;
        }
        return wareHouse;
    }

    @Override
    public boolean isWithinBuildingZone(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap != null) {
            Set<BlockPos> capList = cap.getAllClaimingBuildings().get(this.colony.getID());
            return capList != null && capList.size() >= (Integer)MineColonies.getConfig().getServer().colonyLoadStrictness.get();
        }
        return false;
    }

    @Override
    public IBuilding getHouseWithSpareBed() {
        for (IBuilding building : this.buildings.values()) {
            LivingBuildingModule module;
            if (!building.hasModule(LivingBuildingModule.class) || (module = building.getFirstModuleOccurance(LivingBuildingModule.class)).getAssignedCitizen().size() >= module.getModuleMax()) continue;
            return building;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<BlockPos, IBuilding> getBuildings() {
        return this.buildings;
    }

    @Override
    @Nullable
    public ITownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public int getMysticalSiteMaxBuildingLevel() {
        int maxLevel = 0;
        if (this.hasMysticalSite()) {
            for (IMysticalSite mysticalSite : this.mysticalSites) {
                if (mysticalSite.getBuildingLevel() <= maxLevel) continue;
                maxLevel = mysticalSite.getBuildingLevel();
            }
        }
        return maxLevel;
    }

    @Override
    public boolean hasWarehouse() {
        return !this.wareHouses.isEmpty();
    }

    @Override
    public boolean hasMysticalSite() {
        return !this.mysticalSites.isEmpty();
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    @NotNull
    public List<BlockPos> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public void addNewField(AbstractScarecrowTileEntity tileEntity, BlockPos pos, Level world) {
        this.addField(pos);
        this.markFieldsDirty();
    }

    @Override
    public <B extends IBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((IBuilding)type.cast(this.buildings.get((Object)buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public ScarecrowTileEntity getFreeField(int owner, Level world) {
        for (BlockPos pos : this.fields) {
            BlockEntity field = world.m_7702_(pos);
            if (!(field instanceof ScarecrowTileEntity) || ((ScarecrowTileEntity)field).isTaken()) continue;
            return (ScarecrowTileEntity)field;
        }
        return null;
    }

    @Override
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding tileEntity, Level world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey((Object)tileEntity.getPosition())) {
            @Nullable IBuilding building = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                building.upgradeBuildingLevelToSchematicData();
                Log.getLogger().info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.m_58900_().getClass(), tileEntity.getPosition()));
                building.setIsMirrored(tileEntity.isMirrored());
                if (!tileEntity.getStyle().isEmpty()) {
                    building.setStyle(tileEntity.getStyle());
                } else {
                    building.setStyle(this.colony.getStyle());
                }
                if (world != null && !(building instanceof IRSComponent)) {
                    building.onPlacement();
                    ConstructionTapeHelper.placeConstructionTape(building.getCorners(), world);
                }
                this.colony.getRequestManager().onProviderAddedToColony(building);
                this.setMaxChunk(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.m_58900_().getClass(), tileEntity.getPosition()), (Throwable)new Exception());
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.colony.getPackageManager().updateSubscribers();
            return building;
        }
        return null;
    }

    @Override
    public void removeBuilding(@NotNull IBuilding building, Set<ServerPlayer> subscribers) {
        if (this.buildings.containsKey((Object)building.getID())) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (IBuilding tbuilding : this.buildings.values()) {
                if (tbuilding == building) continue;
                builder.put((Object)tbuilding.getID(), (Object)tbuilding);
            }
            this.buildings = builder.build();
            for (ServerPlayer player : subscribers) {
                Network.getNetwork().sendToPlayer(new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouses.remove(building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.remove(building);
        }
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
            building.cancelAllRequestsOfCitizen(citizen);
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        this.colony.getRequestManager().onRequesterRemovedFromColony(building.getRequester());
        this.colony.getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public void removeField(BlockPos pos) {
        this.markFieldsDirty();
        this.fields.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public BlockPos getBestBuilding(AbstractEntityCitizen citizen, Class<? extends IBuilding> clazz) {
        return this.getBestBuilding(citizen.m_142538_(), clazz);
    }

    @Override
    public BlockPos getBestBuilding(BlockPos citizen, Class<? extends IBuilding> clazz) {
        double distance = Double.MAX_VALUE;
        BlockPos goodCook = null;
        for (IBuilding building : this.buildings.values()) {
            double localDistance;
            if (!clazz.isInstance(building) || building.getBuildingLevel() <= 0 || !((localDistance = building.getPosition().m_123331_((Vec3i)citizen)) < distance)) continue;
            distance = localDistance;
            goodCook = building.getPosition();
        }
        return goodCook;
    }

    @Override
    public BlockPos getRandomBuilding(Predicate<IBuilding> filterPredicate) {
        ArrayList<IBuilding> allowedBuildings = new ArrayList<IBuilding>();
        for (IBuilding building : this.buildings.values()) {
            if (!filterPredicate.test(building)) continue;
            allowedBuildings.add(building);
        }
        if (allowedBuildings.isEmpty()) {
            return null;
        }
        Collections.shuffle(allowedBuildings);
        return ((IBuilding)allowedBuildings.get(0)).getPosition();
    }

    @Override
    public boolean hasGuardBuildingNear(IBuilding building) {
        if (building == null) {
            return true;
        }
        for (IBuilding colonyBuilding : this.getBuildings().values()) {
            BoundingBox guardedRegion;
            if (!(colonyBuilding instanceof IGuardBuilding) || !(guardedRegion = BlockPosUtil.getChunkAlignedBB(colonyBuilding.getPosition(), colonyBuilding.getClaimRadius(colonyBuilding.getBuildingLevel()))).m_71051_((Vec3i)building.getPosition())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void guardBuildingChangedAt(IBuilding guardBuilding, int newLevel) {
        int claimRadius = guardBuilding.getClaimRadius(Math.max(guardBuilding.getBuildingLevel(), newLevel));
        BoundingBox guardedRegion = BlockPosUtil.getChunkAlignedBB(guardBuilding.getPosition(), claimRadius);
        for (IBuilding building : this.getBuildings().values()) {
            if (!guardedRegion.m_71051_((Vec3i)building.getPosition())) continue;
            building.resetGuardBuildingNear();
        }
    }

    @Override
    public void setTownHall(@Nullable ITownHall building) {
        this.townHall = building;
    }

    @Override
    public List<IWareHouse> getWareHouses() {
        return this.wareHouses;
    }

    @Override
    public void removeWareHouse(IWareHouse wareHouse) {
        this.wareHouses.remove(wareHouse);
    }

    @Override
    public List<IMysticalSite> getMysticalSites() {
        return this.mysticalSites;
    }

    @Override
    public void removeMysticalSite(IMysticalSite mysticalSite) {
        this.mysticalSites.remove(mysticalSite);
    }

    private void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    private void addBuilding(@NotNull IBuilding building) {
        this.buildings = new ImmutableMap.Builder().putAll(this.buildings).put((Object)building.getID(), (Object)building).build();
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (ITownHall)building;
        }
        if (building instanceof BuildingWareHouse) {
            this.wareHouses.add((IWareHouse)building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.add((IMysticalSite)building);
        }
    }

    private void sendBuildingPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isBuildingsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isBuildingsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!building.isDirty() && newSubscribers.isEmpty()) continue;
                players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewBuildingViewMessage(building), (ServerPlayer)player));
            }
        }
    }

    private void sendFieldPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isFieldsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isFieldsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingFarmer)) continue;
                players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewBuildingViewMessage(building), (ServerPlayer)player));
            }
        }
    }

    private void addField(@NotNull BlockPos pos) {
        if (!this.fields.contains(pos)) {
            this.fields.add(pos);
        }
        this.colony.markDirty();
    }

    @Override
    public boolean canPlaceAt(Block block, BlockPos pos, Player player) {
        if (block instanceof BlockHutTownHall) {
            if (this.colony.hasTownHall()) {
                if (this.colony.getWorld() != null && !this.colony.getWorld().f_46443_) {
                    LanguageHandler.sendPlayerMessage((Player)player, (String)"tile.blockhuttownhall.messageplacedalready", (Object[])new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (block instanceof BlockHutTavern) {
            for (IBuilding building : this.buildings.values()) {
                if (!building.hasModule(TavernBuildingModule.class)) continue;
                LanguageHandler.sendPlayerMessage((Player)player, (String)"tile.blockhut.tavern.limit", (Object[])new Object[0]);
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
        if (building != null) {
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.markBuildingsDirty();
        }
    }
}

