/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.blocks.BlockMinecoloniesGrave;
import com.minecolonies.coremod.colony.Colony;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class GraveManager
implements IGraveManager {
    @NotNull
    private final Map<BlockPos, Boolean> graves = new HashMap<BlockPos, Boolean>();
    private final Colony colony;

    public GraveManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.graves.clear();
        ListTag gravesTagList = compound.m_128437_("graves", 10);
        for (int i = 0; i < gravesTagList.size(); ++i) {
            CompoundTag graveCompound = gravesTagList.m_128728_(i);
            if (!graveCompound.m_128441_("pos") || !graveCompound.m_128441_("reserved")) continue;
            this.graves.put(BlockPosUtil.read(graveCompound, "pos"), graveCompound.m_128471_("reserved"));
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag gravesTagList = new ListTag();
        for (BlockPos blockPos : this.graves.keySet()) {
            @NotNull CompoundTag graveCompound = new CompoundTag();
            BlockPosUtil.write(graveCompound, "pos", blockPos);
            graveCompound.m_128379_("reserved", this.graves.get(blockPos).booleanValue());
            gravesTagList.add((Object)graveCompound);
        }
        compound.m_128365_("graves", (Tag)gravesTagList);
    }

    @Override
    public void onColonyTick(IColony colony) {
        Iterator<BlockPos> iterator = this.graves.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), pos)) continue;
            BlockEntity graveEntity = colony.getWorld().m_7702_(pos);
            if (!(graveEntity instanceof TileEntityGrave)) {
                iterator.remove();
                colony.markDirty();
                continue;
            }
            if (((TileEntityGrave)graveEntity).onColonyTick(500.0)) continue;
            iterator.remove();
            colony.markDirty();
        }
    }

    @Override
    @NotNull
    public Map<BlockPos, Boolean> getGraves() {
        return this.graves;
    }

    @Override
    public boolean addNewGrave(@NotNull BlockPos pos) {
        TileEntityGrave graveEntity = (TileEntityGrave)this.colony.getWorld().m_7702_(pos);
        if (graveEntity == null) {
            return false;
        }
        if (this.graves.containsKey(pos)) {
            return true;
        }
        this.graves.put(pos, false);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void removeGrave(@NotNull BlockPos pos) {
        this.graves.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public boolean reserveGrave(@NotNull BlockPos pos) {
        if (!this.graves.containsKey(pos) || this.graves.get(pos).booleanValue()) {
            return false;
        }
        this.graves.put(pos, true);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void unReserveGrave(@NotNull BlockPos pos) {
        if (this.graves.containsKey(pos) && this.graves.get(pos).booleanValue()) {
            this.graves.put(pos, false);
            this.colony.markDirty();
        }
    }

    @Override
    public BlockPos reserveNextFreeGrave() {
        for (BlockPos pos : new ArrayList<BlockPos>(this.graves.keySet())) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), pos)) continue;
            BlockEntity graveEntity = this.colony.getWorld().m_7702_(pos);
            if (!(graveEntity instanceof TileEntityGrave)) {
                this.graves.remove(pos);
                continue;
            }
            if (!this.reserveGrave(pos)) continue;
            return pos;
        }
        return null;
    }

    @Override
    public void createCitizenGrave(Level world, BlockPos pos, ICitizenData citizenData) {
        BlockPos firstValidPosition = BlockPosUtil.findAround(world, pos, 15, 10, (blockAccess, current) -> blockAccess.m_8055_(current).m_60767_() == Material.f_76296_ && blockAccess.m_8055_(current.m_7495_()).m_60767_().m_76333_());
        if (firstValidPosition != null) {
            world.m_46597_(firstValidPosition, BlockMinecoloniesGrave.getPlacementState(ModBlocks.blockGrave.m_49966_(), new TileEntityGrave(pos, ModBlocks.blockGrave.m_49966_()), firstValidPosition));
            TileEntityGrave graveEntity = (TileEntityGrave)world.m_7702_(firstValidPosition);
            if (!InventoryUtils.transferAllItemHandler((IItemHandler)citizenData.getInventory(), (IItemHandler)graveEntity.getInventory())) {
                InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
            graveEntity.delayDecayTimer(this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GRAVE_DECAY_BONUS));
            GraveData graveData = new GraveData();
            graveData.setCitizenName(citizenData.getName());
            if (citizenData.getJob() != null) {
                TranslatableComponent jobName = new TranslatableComponent(citizenData.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase());
                graveData.setCitizenJobName(jobName.getString());
            }
            graveData.setCitizenDataNBT((CompoundTag)citizenData.serializeNBT());
            graveEntity.setGraveData(graveData);
            this.colony.getGraveManager().addNewGrave(firstValidPosition);
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.gravespawned", (Object[])new Object[0]);
        } else {
            InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }
}

