/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ColonyProgressType;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ProgressManager
implements IProgressManager {
    private final List<ColonyProgressType> notifiedProgress = new ArrayList<ColonyProgressType>();
    private final Colony colony;
    private boolean printProgress = true;

    public ProgressManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void progressBuildingPlacement(Block block) {
        if (block == ModBlocks.blockHutTownHall) {
            this.trigger(ColonyProgressType.COLONY_FOUNDED);
        } else if (block == ModBlocks.blockHutBuilder) {
            this.trigger(ColonyProgressType.BUILDER_PLACED);
        }
    }

    @Override
    public void progressCitizenSpawn(int total, int employed) {
        if (total == 1) {
            this.trigger(ColonyProgressType.FIRST_CITIZEN_SPAWNED);
        } else if (total == 6) {
            this.trigger(ColonyProgressType.SIX_CITIZENS_SPAWNED);
        } else if (total == 7) {
            this.trigger(ColonyProgressType.SEVEN_CITIZENS_SPAWNED);
        } else if (total == 8) {
            this.trigger(ColonyProgressType.EIGHT_CITIZENS_SPAWNED);
        } else if (total == 9) {
            this.trigger(ColonyProgressType.NINE_CITIZENS_SPAWNED);
        } else if (total == 10) {
            this.trigger(ColonyProgressType.TEN_CITIZENS_SPAWNED);
        } else if ((double)total == this.colony.getCitizenManager().maxCitizensFromResearch()) {
            this.trigger(ColonyProgressType.CITIZEN_CAP_MET);
        } else if (total >= 11 && employed >= 4) {
            this.trigger(ColonyProgressType.NOT_ENOUGH_JOBS);
        }
    }

    @Override
    public void progressWorkOrderPlacement(IWorkOrder workOrder) {
        if (workOrder instanceof WorkOrderBuildBuilding && ((WorkOrderBuildBuilding)workOrder).getStructureName().contains("Builder")) {
            this.trigger(ColonyProgressType.BUILT_ENQUEUED);
        }
    }

    @Override
    public void progressBuildBuilding(IBuilding building, int totalLevels, int totalHousing) {
        if (building instanceof BuildingBuilder) {
            this.trigger(ColonyProgressType.BUILDER_BUILT);
        } else if (building instanceof BuildingMiner || building instanceof BuildingLumberjack) {
            this.trigger(ColonyProgressType.RESOURCE_PROD_BUILT);
        } else if (building instanceof BuildingFisherman || building instanceof BuildingFarmer) {
            this.trigger(ColonyProgressType.FOOD_PROD_BUILT);
        } else if (building instanceof BuildingWareHouse) {
            this.trigger(ColonyProgressType.WAREHOUSE_BUILT);
        } else if (building.hasModule(TavernBuildingModule.class)) {
            this.trigger(ColonyProgressType.TAVERN_BUILT);
        }
        if (totalHousing == 4 && building.hasModule(LivingBuildingModule.class)) {
            this.trigger(ColonyProgressType.ALL_CITIZENS_HOMED);
        }
        if (totalLevels == 20) {
            this.trigger(ColonyProgressType.TWENTY_BUILDING_LEVELS);
        }
    }

    @Override
    public void progressEmploy(int employed) {
        if (employed == 4) {
            this.trigger(ColonyProgressType.FOUR_CITIZEN_EMPLOYED);
        }
    }

    @Override
    public void progressEmploymentModeChange() {
        this.trigger(ColonyProgressType.MANUAL_EMPLOYMENT_ON);
    }

    @Override
    public void trigger(ColonyProgressType type) {
        if (!this.printProgress) {
            return;
        }
        if (!this.notifiedProgress.contains((Object)type)) {
            this.notifiedProgress.add(type);
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)("com.minecolonies.coremod.progress." + type.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
            this.colony.markDirty();
        }
    }

    @Override
    public void togglePrintProgress() {
        this.printProgress = !this.printProgress;
        this.colony.markDirty();
    }

    @Override
    public boolean isPrintingProgress() {
        return this.printProgress;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.notifiedProgress.clear();
        CompoundTag progressCompound = compound.m_128469_("progressManager");
        ListTag progressTags = progressCompound.m_128437_("progressList", 10);
        this.notifiedProgress.addAll(NBTUtils.streamCompound(progressTags).map(progressTypeCompound -> ColonyProgressType.values()[progressTypeCompound.m_128451_("progressType")]).collect(Collectors.toList()));
        this.printProgress = progressCompound.m_128471_("printProgrss");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        CompoundTag progressCompound = new CompoundTag();
        @NotNull ListTag progressTagList = this.notifiedProgress.stream().map(this::writeProgressTypeToNBT).collect(NBTUtils.toListNBT());
        progressCompound.m_128365_("progressList", (Tag)progressTagList);
        progressCompound.m_128379_("printProgrss", this.printProgress);
        compound.m_128365_("progressManager", (Tag)progressCompound);
    }

    private CompoundTag writeProgressTypeToNBT(ColonyProgressType type) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("progressType", type.ordinal());
        return compound;
    }
}

