/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemDeliveryManJobDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemDeliveryManJobDataStore
implements IRequestSystemDeliveryManJobDataStore {
    private IToken<?> id;
    private final LinkedList<IToken<?>> queue;
    private final Set<IToken<?>> ongoingDeliveries;

    public StandardRequestSystemDeliveryManJobDataStore(IToken<?> id, LinkedList<IToken<?>> queue, Set<IToken<?>> ongoingDeliveries) {
        this.id = id;
        this.queue = queue;
        this.ongoingDeliveries = ongoingDeliveries;
    }

    public StandardRequestSystemDeliveryManJobDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new LinkedList(), new HashSet());
    }

    @Override
    public LinkedList<IToken<?>> getQueue() {
        return this.queue;
    }

    @Override
    public Set<IToken<?>> getOngoingDeliveries() {
        return this.ongoingDeliveries;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemDeliveryManJobDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemDeliveryManJobDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemDeliveryManJobDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemDeliveryManJobDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemDeliveryManJobDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemDeliveryManJobDataStore standardRequestSystemDeliveryManJobDataStore) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("Token", (Tag)controller.serialize(standardRequestSystemDeliveryManJobDataStore.id));
            compound.m_128365_("List", (Tag)standardRequestSystemDeliveryManJobDataStore.queue.stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
            compound.m_128365_("OngoingList", (Tag)standardRequestSystemDeliveryManJobDataStore.ongoingDeliveries.stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemDeliveryManJobDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.m_128469_("Token"));
            LinkedList queue = NBTUtils.streamCompound(nbt.m_128437_("List", 10)).map(CompoundNBT -> (IToken)controller.deserialize((CompoundTag)CompoundNBT)).collect(Collectors.toCollection(LinkedList::new));
            HashSet ongoingDeliveries = NBTUtils.streamCompound(nbt.m_128437_("OngoingList", 10)).map(CompoundNBT -> (IToken)controller.deserialize((CompoundTag)CompoundNBT)).collect(Collectors.toCollection(HashSet::new));
            return new StandardRequestSystemDeliveryManJobDataStore(token, queue, ongoingDeliveries);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestSystemDeliveryManJobDataStore input, FriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.queue.size());
            input.queue.forEach(entry -> controller.serialize(packetBuffer, entry));
            packetBuffer.writeInt(input.ongoingDeliveries.size());
            input.ongoingDeliveries.forEach(entry -> controller.serialize(packetBuffer, entry));
        }

        @Override
        @NotNull
        public StandardRequestSystemDeliveryManJobDataStore deserialize(IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            LinkedList queue = new LinkedList();
            HashSet ongoingDeliveries = new HashSet();
            int queueSize = buffer.readInt();
            for (int i = 0; i < queueSize; ++i) {
                queue.add((IToken)controller.deserialize(buffer));
            }
            int ongoingSize = buffer.readInt();
            for (int i = 0; i < ongoingSize; ++i) {
                queue.add((IToken)controller.deserialize(buffer));
            }
            return new StandardRequestSystemDeliveryManJobDataStore(id, queue, ongoingDeliveries);
        }

        @Override
        public short getSerializationId() {
            return 38;
        }
    }
}

