/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PublicWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token, JobEntry entry) {
        super(location, token, entry, true);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        CraftingModuleView moduleView;
        IRequester requester = manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation());
        if (requester instanceof IBuildingView && (moduleView = ((IBuildingView)requester).getModuleViewMatching(CraftingModuleView.class, m -> m.getJobEntry() == this.getJobEntry())) != null) {
            return new TranslatableComponent(moduleView.getJobEntry().getTranslationKey());
        }
        return super.getRequesterDisplayName(manager, request);
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuilding building, Predicate<ItemStack> stackPredicate) {
        for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
            if (module.getFirstRecipe(stackPredicate) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count, int minCount, IToken<?> recipeStorage) {
        return new PublicCrafting(stack, count, recipeStorage);
    }
}

