/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRetryable;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardRetryingRequestResolver
implements IRetryingRequestResolver {
    private static final Integer CONST_RETRYING_ID_SCALE = -20000;
    private IRequestManager manager;
    private final ILocation location;
    private final IToken<?> id;
    private IToken<?> current;
    private final HashMap<IToken<?>, Integer> delays = new HashMap();
    private final HashMap<IToken<?>, Integer> assignedRequests = new HashMap();

    public StandardRetryingRequestResolver(IFactoryController factoryController, IRequestManager manager) {
        this.updateManager(manager);
        this.id = factoryController.getNewInstance(TypeConstants.ITOKEN, manager.getColony().getID() * CONST_RETRYING_ID_SCALE, new Object[0]);
        this.location = factoryController.getNewInstance(TypeConstants.ILOCATION, manager.getColony().getCenter(), manager.getColony().getDimension());
    }

    public StandardRetryingRequestResolver(IToken<?> id, ILocation location) {
        this.id = id;
        this.location = location;
    }

    @Override
    public void updateManager(IRequestManager manager) {
        this.manager = manager;
    }

    @Override
    public int getMaximalTries() {
        return (Integer)MineColonies.getConfig().getServer().maximalRetries.get();
    }

    @Override
    public int getMaximalDelayBetweenRetriesInTicks() {
        return (Integer)MineColonies.getConfig().getServer().delayBetweenRetries.get();
    }

    @Override
    public int getCurrentReassignmentAttempt() {
        return this.isReassigning() ? -1 : this.assignedRequests.get(this.getCurrentlyBeingReassignedRequest()) + 1;
    }

    @Override
    @Nullable
    public IToken<?> getCurrentlyBeingReassignedRequest() {
        return this.current;
    }

    @Override
    public TypeToken<? extends IRetryable> getRequestType() {
        return TypeConstants.RETRYABLE;
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IRetryable> requestToCheck) {
        return this.getCurrentlyBeingReassignedRequest() == null || requestToCheck.getId() != this.getCurrentlyBeingReassignedRequest() || this.getCurrentReassignmentAttempt() < this.getMaximalTries();
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) {
        return ImmutableList.of();
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) throws RuntimeException {
        this.delays.put((IToken<?>)request.getId(), this.getMaximalDelayBetweenRetriesInTicks());
        this.assignedRequests.put((IToken<?>)request.getId(), this.assignedRequests.containsKey(request.getId()) ? this.assignedRequests.get(request.getId()) + 1 : 1);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) {
        if (this.assignedRequests.containsKey(request.getId())) {
            this.delays.remove(request.getId());
            this.assignedRequests.remove(request.getId());
        }
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRetryable> request) {
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public void tick() {
        this.manager.getLogger().debug("Starting reassignment.");
        this.getAllAssignedRequests().forEach(t -> {
            Integer current = this.delays.remove(t);
            current = current - 1;
            this.delays.put((IToken<?>)t, current);
        });
        Set retryables = this.delays.keySet().stream().filter(t -> this.delays.get(t) == 0).collect(Collectors.toSet());
        Set<IToken> successfully = retryables.stream().filter(t -> {
            IToken<?> resultingResolver;
            ImmutableSet blackList = this.assignedRequests.get(t) < this.getMaximalTries() ? ImmutableSet.of() : ImmutableSet.of(this.id);
            Integer currentAttempt = this.assignedRequests.get(t);
            this.setCurrent((IToken<?>)t);
            try {
                resultingResolver = this.manager.reassignRequest((IToken<?>)t, (Collection<IToken<?>>)blackList);
            }
            catch (Exception ex) {
                this.assignedRequests.remove(t);
                this.delays.remove(t);
                return false;
            }
            this.setCurrent(null);
            currentAttempt = currentAttempt + 1;
            this.assignedRequests.put((IToken<?>)t, currentAttempt);
            if (resultingResolver != null && !resultingResolver.equals(this.getId())) {
                this.assignedRequests.remove(t);
                this.delays.remove(t);
            }
            return resultingResolver != null;
        }).collect(Collectors.toSet());
        successfully.forEach(t -> this.manager.getLogger().debug("Failed to reassign a retryable request: " + this.id));
        this.manager.getLogger().debug("Finished reassignment.");
    }

    @Override
    public ImmutableList<IToken<?>> getAllAssignedRequests() {
        return ImmutableList.copyOf(this.assignedRequests.keySet());
    }

    @Override
    public void onSystemReset() {
        this.assignedRequests.clear();
        this.delays.clear();
    }

    public void setCurrent(@Nullable IToken<?> token) {
        this.current = token;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return new TextComponent("Player");
    }

    public void updateData(@NotNull Map<IToken<?>, Integer> newAssignedRequests, @NotNull Map<IToken<?>, Integer> newDelays) {
        this.assignedRequests.clear();
        this.assignedRequests.putAll(newAssignedRequests);
        this.delays.clear();
        this.delays.putAll(newDelays);
    }

    public Map<IToken<?>, Integer> getDelays() {
        return this.delays;
    }

    public Map<IToken<?>, Integer> getAssignedRequests() {
        return this.assignedRequests;
    }

    @Override
    public void onColonyUpdate(@NotNull IRequestManager manager, @NotNull Predicate<IRequest<?>> shouldTriggerReassign) {
        new ArrayList(this.assignedRequests.keySet()).stream().map(manager::getRequestForToken).forEach(request -> {
            block2: {
                block3: {
                    if (request == null) break block2;
                    if (!shouldTriggerReassign.test((IRequest<?>)request)) break block3;
                    IToken<?> newResolverToken = manager.reassignRequest((IToken<?>)request.getId(), (Collection<IToken<?>>)ImmutableList.of(this.getId()));
                    if (newResolverToken == null || newResolverToken.equals(this.getId())) break block2;
                    this.assignedRequests.remove(request.getId());
                    break block2;
                }
                IRequest<?> req = request;
                while (req.hasParent()) {
                    IToken<?> newResolverToken;
                    if ((req = manager.getRequestForToken((IToken<?>)req.getParent())) == null || !shouldTriggerReassign.test(req)) continue;
                    if (req.hasChildren()) {
                        ImmutableCollection<IToken<?>> currentChildren = req.getChildren();
                        currentChildren.forEach(((IStandardRequestManager)manager).getRequestHandler()::onRequestCancelledDirectly);
                    }
                    if ((newResolverToken = manager.reassignRequest((IToken<?>)req.getId(), (Collection<IToken<?>>)ImmutableList.of(this.getId()))) == this.getId()) continue;
                    this.assignedRequests.remove(request.getId());
                    break;
                }
            }
        });
    }
}

