/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class PrivateWorkerCraftingRequestResolverFactory
implements IRequestResolverFactory<PrivateWorkerCraftingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_JOB = "Job";

    @Override
    @NotNull
    public TypeToken<? extends PrivateWorkerCraftingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(PrivateWorkerCraftingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) {
        return new PrivateWorkerCraftingRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN), (JobEntry)((Object)context[0]));
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull PrivateWorkerCraftingRequestResolver privateWorkerCraftingRequestResolverFactory) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(privateWorkerCraftingRequestResolverFactory.getId()));
        compound.m_128365_(NBT_LOCATION, (Tag)controller.serialize(privateWorkerCraftingRequestResolverFactory.getLocation()));
        compound.m_128359_(NBT_JOB, IJobRegistry.getInstance().getKey((IForgeRegistryEntry)privateWorkerCraftingRequestResolverFactory.getJobEntry()).toString());
        return compound;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserialize(nbt.m_128469_(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.m_128469_(NBT_LOCATION));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(nbt.m_128461_(NBT_JOB)));
        return new PrivateWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public void serialize(IFactoryController controller, PrivateWorkerCraftingRequestResolver input, FriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
        packetBuffer.writeRegistryId((IForgeRegistryEntry)input.getJobEntry());
    }

    @Override
    public PrivateWorkerCraftingRequestResolver deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        JobEntry entry = (JobEntry)buffer.readRegistryId();
        return new PrivateWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public short getSerializationId() {
        return 19;
    }
}

