/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StandardRetryingRequestResolver;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StandardRetryingRequestResolverFactory
implements IFactory<IRequestManager, StandardRetryingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_VALUE = "Value";
    private static final String NBT_TRIES = "Requests";
    private static final String NBT_DELAYS = "Delays";

    @Override
    @NotNull
    public TypeToken<? extends StandardRetryingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(StandardRetryingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends IRequestManager> getFactoryInputType() {
        return TypeToken.of(IRequestManager.class);
    }

    @Override
    @NotNull
    public StandardRetryingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull IRequestManager iRequestManager, Object ... context) throws IllegalArgumentException {
        if (context.length != 0) {
            throw new IllegalArgumentException("Context is not empty.");
        }
        return new StandardRetryingRequestResolver(factoryController, iRequestManager);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRetryingRequestResolver standardRetryingRequestResolver) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_TRIES, (Tag)standardRetryingRequestResolver.getAssignedRequests().keySet().stream().map(t -> {
            CompoundTag assignmentCompound = new CompoundTag();
            assignmentCompound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(t));
            assignmentCompound.m_128405_(NBT_VALUE, standardRetryingRequestResolver.getAssignedRequests().get(t).intValue());
            return assignmentCompound;
        }).collect(NBTUtils.toListNBT()));
        compound.m_128365_(NBT_DELAYS, (Tag)standardRetryingRequestResolver.getDelays().keySet().stream().map(t -> {
            CompoundTag delayCompound = new CompoundTag();
            delayCompound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(t));
            delayCompound.m_128405_(NBT_VALUE, standardRetryingRequestResolver.getDelays().get(t).intValue());
            return delayCompound;
        }).collect(NBTUtils.toListNBT()));
        compound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(standardRetryingRequestResolver.getId()));
        compound.m_128365_(NBT_LOCATION, (Tag)controller.serialize(standardRetryingRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public StandardRetryingRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        Map<IToken<?>, Integer> assignments = NBTUtils.streamCompound(nbt.m_128437_(NBT_TRIES, 10)).map(assignmentCompound -> {
            IToken token = (IToken)controller.deserialize(assignmentCompound.m_128469_(NBT_TOKEN));
            Integer tries = assignmentCompound.m_128451_(NBT_VALUE);
            return new AbstractMap.SimpleEntry<IToken, Integer>(token, tries);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Map<IToken<?>, Integer> delays = NBTUtils.streamCompound(nbt.m_128437_(NBT_DELAYS, 10)).map(assignmentCompound -> {
            IToken token = (IToken)controller.deserialize(assignmentCompound.m_128469_(NBT_TOKEN));
            Integer tries = assignmentCompound.m_128451_(NBT_VALUE);
            return new AbstractMap.SimpleEntry<IToken, Integer>(token, tries);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        IToken token = (IToken)controller.deserialize(nbt.m_128469_(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.m_128469_(NBT_LOCATION));
        StandardRetryingRequestResolver retryingRequestResolver = new StandardRetryingRequestResolver(token, location);
        retryingRequestResolver.updateData(assignments, delays);
        return retryingRequestResolver;
    }

    @Override
    public void serialize(IFactoryController controller, StandardRetryingRequestResolver input, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(input.getAssignedRequests().size());
        input.getAssignedRequests().forEach((key, value) -> {
            controller.serialize(packetBuffer, key);
            packetBuffer.writeInt(value.intValue());
        });
        packetBuffer.writeInt(input.getDelays().size());
        input.getDelays().forEach((key, value) -> {
            controller.serialize(packetBuffer, key);
            packetBuffer.writeInt(value.intValue());
        });
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public StandardRetryingRequestResolver deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        HashMap requests = new HashMap();
        int requestsSize = buffer.readInt();
        for (int i = 0; i < requestsSize; ++i) {
            requests.put((IToken)controller.deserialize(buffer), buffer.readInt());
        }
        HashMap delays = new HashMap();
        int delaysSize = buffer.readInt();
        for (int i = 0; i < delaysSize; ++i) {
            delays.put((IToken)controller.deserialize(buffer), buffer.readInt());
        }
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        StandardRetryingRequestResolver resolver = new StandardRetryingRequestResolver(token, location);
        resolver.updateData(requests, delays);
        return resolver;
    }

    @Override
    public short getSerializationId() {
        return 25;
    }
}

