/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildMiner
extends WorkOrderBuildDecoration {
    private BlockPos minerBuilding;

    public WorkOrderBuildMiner() {
    }

    public WorkOrderBuildMiner(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror, BlockPos minerBuilding) {
        super(structureName, workOrderName, rotation, location, mirror);
        this.minerBuilding = minerBuilding;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.minerBuilding = BlockPosUtil.read(compound, "pos");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        BlockPosUtil.write(compound, "pos", this.minerBuilding);
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
    }

    @Override
    public void onRemoved(IColony colony) {
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.minerBuilding) != null;
    }

    public BlockPos getMinerBuilding() {
        return this.minerBuilding;
    }
}

