/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeUtils;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GenericRecipeCategory
extends JobBasedRecipeCategory<IGenericRecipe> {
    @NotNull
    private final BuildingEntry building;
    @NotNull
    private final ICraftingBuildingModule crafting;
    @NotNull
    private final IDrawableStatic arrow;
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;
    private static final int INPUT_SLOT_X = 81;
    private static final int INPUT_SLOT_W = 86;
    private final int outputSlotX;
    private final int outputSlotY;

    public GenericRecipeCategory(@NotNull BuildingEntry building, @NotNull IJob<?> job, @NotNull ICraftingBuildingModule crafting, @NotNull IGuiHelper guiHelper) {
        super(job, Objects.requireNonNull(crafting.getUid()), GenericRecipeCategory.getCatalyst(building), guiHelper);
        this.building = building;
        this.crafting = crafting;
        this.arrow = guiHelper.createDrawable(TEXTURE, 20, 121, 24, 18);
        this.outputSlotX = 51 + (30 - this.slot.getWidth()) / 2;
        this.outputSlotY = 118 - this.slot.getHeight();
    }

    @NotNull
    public Class<? extends IGenericRecipe> getRecipeClass() {
        return IGenericRecipe.class;
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull IGenericRecipe recipe) {
        return recipe.getRestrictions();
    }

    public void setIngredients(@NotNull IGenericRecipe recipe, @NotNull IIngredients ingredients) {
        ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
        if (!GenericRecipeCategory.isLootBasedRecipe(recipe)) {
            outputs.add(recipe.getAllMultiOutputs());
        }
        outputs.addAll(recipe.getAdditionalOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()));
        if (recipe.getLootTable() != null) {
            List<LootTableAnalyzer.LootDrop> drops = GenericRecipeCategory.getLootDrops(recipe.getLootTable());
            outputs.addAll(drops.stream().map(LootTableAnalyzer.LootDrop::getItemStacks).collect(Collectors.toList()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutputLists(VanillaTypes.ITEM, outputs);
    }

    public void setRecipe(@NotNull IRecipeLayout layout, @NotNull IGenericRecipe recipe, @NotNull IIngredients ingredients) {
        if (GenericRecipeCategory.isLootBasedRecipe(recipe)) {
            this.setLootBasedRecipe(layout, recipe, ingredients);
        } else {
            this.setNormalRecipe(layout, recipe, ingredients);
        }
    }

    private void setNormalRecipe(@NotNull IRecipeLayout layout, @NotNull IGenericRecipe recipe, @NotNull IIngredients ingredients) {
        List<List<ItemStack>> inputs;
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        int x = this.outputSlotX;
        int y = this.outputSlotY;
        int slot = 0;
        guiItemStacks.init(slot, false, x, y);
        guiItemStacks.setBackground(slot, (IDrawable)this.slot);
        guiItemStacks.set(slot, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        x += this.slot.getWidth();
        ++slot;
        for (ItemStack itemStack : recipe.getAdditionalOutputs()) {
            guiItemStacks.init(slot, false, x, y);
            guiItemStacks.setBackground(slot, (IDrawable)this.slot);
            guiItemStacks.set(slot, itemStack);
            x += this.slot.getWidth();
            ++slot;
        }
        if (recipe.getLootTable() != null) {
            List<LootTableAnalyzer.LootDrop> drops = GenericRecipeCategory.getLootDrops(recipe.getLootTable());
            guiItemStacks.addTooltipCallback((ITooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(slot, drops));
            for (LootTableAnalyzer.LootDrop drop : drops) {
                guiItemStacks.init(slot, false, x, y);
                guiItemStacks.setBackground(slot, (IDrawable)this.chanceSlot);
                guiItemStacks.set(slot, drop.getItemStacks());
                x += this.chanceSlot.getWidth();
                ++slot;
            }
        }
        if (!(inputs = recipe.getInputs()).isEmpty()) {
            int n = 86 / this.slot.getWidth();
            int inputRows = (inputs.size() + n - 1) / n;
            int inputColumns = (inputs.size() + inputRows - 1) / inputRows;
            x = 81;
            y = 46 + (71 - inputRows * this.slot.getHeight()) / 2;
            int c = 0;
            for (List<ItemStack> input : inputs) {
                guiItemStacks.init(slot, true, x, y);
                guiItemStacks.set(slot, input);
                ++slot;
                if (++c >= inputColumns) {
                    c = 0;
                    x = 81;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    private void setLootBasedRecipe(@NotNull IRecipeLayout layout, @NotNull IGenericRecipe recipe, @NotNull IIngredients ingredients) {
        assert (recipe.getLootTable() != null);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        List<LootTableAnalyzer.LootDrop> drops = GenericRecipeCategory.getLootDrops(recipe.getLootTable());
        int x = 53;
        int y = 46;
        int slot = 0;
        List<List<ItemStack>> inputs = recipe.getInputs();
        if (!inputs.isEmpty()) {
            for (List<ItemStack> input : inputs) {
                guiItemStacks.init(slot, false, x, y);
                guiItemStacks.set(slot, input);
                ++slot;
                x += this.slot.getWidth() + 2;
            }
        }
        boolean showLootTooltip = true;
        if (drops.isEmpty()) {
            showLootTooltip = false;
            drops.addAll(recipe.getAdditionalOutputs().stream().map(stack -> new LootTableAnalyzer.LootDrop(Collections.singletonList(stack), 0.0f, 0.0f, false)).collect(Collectors.toList()));
        }
        if (!drops.isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = (drops.size() + initialColumns - 1) / initialColumns;
            int columns = (drops.size() + rows - 1) / rows;
            x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            if (showLootTooltip) {
                guiItemStacks.addTooltipCallback((ITooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(slot, drops));
            }
            for (LootTableAnalyzer.LootDrop drop : drops) {
                guiItemStacks.init(slot, true, x, y);
                guiItemStacks.setBackground(slot, (IDrawable)this.chanceSlot);
                guiItemStacks.set(slot, drop.getItemStacks());
                ++slot;
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @Override
    public void draw(@NotNull IGenericRecipe recipe, @NotNull PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        if (!GenericRecipeCategory.isLootBasedRecipe(recipe)) {
            this.arrow.draw(matrixStack, 53, 46 + (71 - this.arrow.getHeight()) / 2);
        }
        if (recipe.getIntermediate() != Blocks.f_50016_) {
            BlockState block = recipe.getIntermediate().m_49966_();
            RenderHelper.renderBlock(matrixStack, block, this.outputSlotX + 8, 52.0f, 100.0f, -30.0f, 30.0f, 16.0f);
        }
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull IGenericRecipe recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>(super.getTooltipStrings(recipe, mouseX, mouseY));
        if (recipe.getIntermediate() != Blocks.f_50016_ && new Rect2i(53, 44, 24, 24).m_110087_((int)mouseX, (int)mouseY)) {
            tooltips.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.intermediate.tip", new Object[]{recipe.getIntermediate().m_49954_()}));
        }
        return tooltips;
    }

    private static boolean isLootBasedRecipe(@NotNull IGenericRecipe recipe) {
        return recipe.getLootTable() != null && recipe.getPrimaryOutput().m_41619_();
    }

    private static List<LootTableAnalyzer.LootDrop> getLootDrops(@NotNull ResourceLocation lootTableId) {
        List<LootTableAnalyzer.LootDrop> drops = CustomRecipeManager.getInstance().getLootDrops(lootTableId);
        return drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull Map<RecipeType<?>, List<IGenericRecipe>> vanilla) {
        IGenericRecipe safeRecipe;
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        if (this.crafting.canLearnCraftingRecipes()) {
            for (IGenericRecipe recipe : vanilla.get(RecipeType.f_44107_)) {
                if (!this.crafting.canLearnLargeRecipes() && recipe.getGridSize() > 2 || (safeRecipe = GenericRecipeUtils.filterInputs(recipe, this.crafting.getIngredientValidator())) == null || !this.crafting.isRecipeCompatible(safeRecipe)) continue;
                recipes.add(safeRecipe);
            }
        }
        if (this.crafting.canLearnFurnaceRecipes()) {
            for (IGenericRecipe recipe : vanilla.get(RecipeType.f_44108_)) {
                safeRecipe = GenericRecipeUtils.filterInputs(recipe, this.crafting.getIngredientValidator());
                if (safeRecipe == null || !this.crafting.isRecipeCompatible(safeRecipe)) continue;
                recipes.add(safeRecipe);
            }
        }
        for (CustomRecipe customRecipe : CustomRecipeManager.getInstance().getRecipes(this.crafting.getCustomRecipeKey())) {
            IRecipeStorage recipeStorage = customRecipe.getRecipeStorage();
            if (!recipeStorage.getAlternateOutputs().isEmpty()) {
                recipes.removeIf(r -> ItemStackUtils.compareItemStacksIgnoreStackSize(recipeStorage.getPrimaryOutput(), r.getPrimaryOutput()));
                recipes.removeIf(r -> recipeStorage.getAlternateOutputs().stream().anyMatch(s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, r.getPrimaryOutput())));
            }
            recipes.add(GenericRecipeUtils.create(customRecipe, recipeStorage));
        }
        recipes.addAll(this.crafting.getAdditionalRecipesForDisplayPurposesOnly());
        return recipes.stream().sorted(Comparator.comparing(IGenericRecipe::getLevelSort).thenComparing(r -> r.getPrimaryOutput().m_41720_().getRegistryName())).collect(Collectors.toList());
    }
}

