/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.NotNull;

public class PrivateCraftingTeachingTransferHandler
implements IRecipeTransferHandler<ContainerCrafting, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public PrivateCraftingTeachingTransferHandler(@NotNull IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Class<ContainerCrafting> getContainerClass() {
        return ContainerCrafting.class;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ContainerCrafting craftingGUIBuilding, @NotNull CraftingRecipe recipe, @NotNull IRecipeLayout recipeLayout, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        ImmutableSet badIndexes;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        HashMap<Integer, ItemStack> guiIngredients = new HashMap<Integer, ItemStack>();
        guiIngredients.put(0, ItemStackUtils.EMPTY);
        guiIngredients.put(1, ItemStackUtils.EMPTY);
        guiIngredients.put(3, ItemStackUtils.EMPTY);
        guiIngredients.put(4, ItemStackUtils.EMPTY);
        if (craftingGUIBuilding.isComplete()) {
            guiIngredients.put(2, ItemStackUtils.EMPTY);
            guiIngredients.put(5, ItemStackUtils.EMPTY);
            guiIngredients.put(6, ItemStackUtils.EMPTY);
            guiIngredients.put(7, ItemStackUtils.EMPTY);
            guiIngredients.put(8, ItemStackUtils.EMPTY);
            badIndexes = ImmutableSet.of();
        } else {
            badIndexes = ImmutableSet.of((Object)2, (Object)5, (Object)6, (Object)7, (Object)8);
        }
        int inputIndex = 0;
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput()) continue;
            if (!ingredient.getAllIngredients().isEmpty()) {
                if (badIndexes.contains(inputIndex)) {
                    TranslatableComponent tooltipMessage = new TranslatableComponent("jei.tooltip.error.recipe.transfer.too.large.player.getInventory()");
                    return this.handlerHelper.createUserErrorForSlots((Component)tooltipMessage, (Collection)badIndexes);
                }
                guiIngredients.put(inputIndex, (ItemStack)ingredient.getDisplayedIngredient());
            }
            ++inputIndex;
        }
        if (doTransfer) {
            CraftingContainer craftMatrix = craftingGUIBuilding.getInv();
            if (craftingGUIBuilding.isComplete()) {
                craftMatrix.m_6836_(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.m_6836_(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.m_6836_(2, (ItemStack)guiIngredients.get(2));
                craftMatrix.m_6836_(3, (ItemStack)guiIngredients.get(3));
                craftMatrix.m_6836_(4, (ItemStack)guiIngredients.get(4));
                craftMatrix.m_6836_(5, (ItemStack)guiIngredients.get(5));
                craftMatrix.m_6836_(6, (ItemStack)guiIngredients.get(6));
                craftMatrix.m_6836_(7, (ItemStack)guiIngredients.get(7));
                craftMatrix.m_6836_(8, (ItemStack)guiIngredients.get(8));
            } else {
                craftMatrix.m_6836_(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.m_6836_(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.m_6836_(2, (ItemStack)guiIngredients.get(3));
                craftMatrix.m_6836_(3, (ItemStack)guiIngredients.get(4));
            }
            TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(guiIngredients, craftingGUIBuilding.isComplete());
            Network.getNetwork().sendToServer(message);
        }
        return null;
    }
}

