/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingBuiltEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingDeconstructedEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingUpgradedEvent;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.entity.ai.util.WorkerLoadOnlyStructureHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIStructure<J, B> {
    protected RequestStage requestState = RequestStage.SOLID;
    protected BlockPos requestProgress = null;

    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.m_21553_(true);
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(blockPos, stage);
    }

    @Override
    public Tuple<BlockPos, BuildingStructureHandler.Stage> getProgressPos() {
        return ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getProgress();
    }

    @Override
    public IAIState loadRequirements() {
        if (!((AbstractJobStructure)this.job).hasBlueprint() || this.structurePlacer == null) {
            this.loadStructure();
            WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()), (Throwable)new Exception());
                ((AbstractJobStructure)this.job).setWorkOrder(null);
                return AIWorkerState.IDLE;
            }
            if (wo instanceof WorkOrderBuildBuilding) {
                IBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getSchematicLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getSchematicLocation()), (Throwable)new Exception());
                    return AIWorkerState.IDLE;
                }
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getWorkOrder().getDisplayName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderBuildMiner)) {
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", wo.getDisplayName());
            }
            return this.getState();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder().isRequested()) {
            return this.afterStructureLoading();
        }
        this.requestMaterialsState();
        return this.getState();
    }

    private void loadStructure() {
        WorkOrderBuildDecoration workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getSchematicLocation();
        if (workOrder instanceof WorkOrderBuildBuilding && this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation(this.world);
        boolean removal = workOrder instanceof WorkOrderBuildRemoval;
        this.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored(), removal);
        workOrder.setCleared(false);
        workOrder.setRequested(removal);
    }

    private void requestMaterialsState() {
        if (Constants.BUILDER_INF_RESOURECES || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval) {
            return;
        }
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
        if (this.requestMaterials()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
        }
        int newQuantity = buildingWorker.getNeededResources().values().stream().mapToInt(ItemStorage::getAmount).sum();
        if (((AbstractJobStructure)this.job).getWorkOrder().getAmountOfRes() == 0 || newQuantity > ((AbstractJobStructure)this.job).getWorkOrder().getAmountOfRes()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setAmountOfRes(newQuantity);
        }
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler structure = new WorkerLoadOnlyStructureHandler(this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), new PlacementSettings(), true, this);
        if (((AbstractJobStructure)this.job).getWorkOrder().getIteratorType().isEmpty() && ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).hasModule(ISettingsModule.class) && ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getSetting(BuildingBuilder.BUILDING_MODE) != null) {
            ((AbstractJobStructure)this.job).getWorkOrder().setIteratorType(((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getSetting(BuildingBuilder.BUILDING_MODE).getValue());
        }
        StructurePlacer placer = new StructurePlacer(structure, ((AbstractJobStructure)this.job).getWorkOrder().getIteratorType());
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
            buildingWorker.resetNeededResources();
            this.requestProgress = AbstractBlueprintIterator.NULL_POS;
            this.requestState = RequestStage.SOLID;
        }
        RequestStage currState = this.requestState;
        switch (currState) {
            case SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !info.getBlockInfo().getState().m_60767_().m_76333_() || AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.DECO;
                }
                return false;
            }
            case DECO: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getBlockInfo().getState().m_60767_().m_76333_() && !AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.ENTITIES;
                }
                return false;
            }
            case ENTITIES: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.SOLID;
                    this.requestProgress = null;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode;
        int n = hashCode = stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
        if (((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getNeededResources().get(stack.m_41778_() + "-" + hashCode) == null) {
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack).booleanValue()) {
            return 0;
        }
        int hashCode = deliveredItemStack.m_41782_() ? deliveredItemStack.m_41783_().hashCode() : 0;
        BuildingBuilderResource resource = ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getNeededResources().get(deliveredItemStack.m_41778_() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((AbstractJobStructure)this.job).getBlueprint() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getBlueprint() == null) {
            return;
        }
        String structureName = ((AbstractJobStructure)this.job).getBlueprint().getName();
        WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo instanceof WorkOrderBuildBuilding) {
            this.sendCompletionMessage(wo);
            wob = (WorkOrderBuild)wo;
            buildingName = wo.getStructureName();
            buildingName = ((String)buildingName).substring(((String)buildingName).indexOf(47) + 1, ((String)buildingName).lastIndexOf(47)) + " " + ((String)buildingName).substring(((String)buildingName).lastIndexOf(47) + 1, ((String)buildingName).lastIndexOf(String.valueOf(wob.getUpgradeLevel())));
            ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(wob.getUpgradeLevel() > 1 ? new BuildingUpgradedEvent(wo.getSchematicLocation(), (String)buildingName, wob.getUpgradeLevel()) : new BuildingBuiltEvent(wo.getSchematicLocation(), (String)buildingName, wob.getUpgradeLevel()));
        } else if (wo instanceof WorkOrderBuildRemoval) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageremovalcomplete", structureName);
            wob = (WorkOrderBuild)wo;
            buildingName = wo.getStructureName();
            buildingName = ((String)buildingName).substring(((String)buildingName).indexOf(47) + 1, ((String)buildingName).lastIndexOf(47)) + " " + ((String)buildingName).substring(((String)buildingName).lastIndexOf(47) + 1, ((String)buildingName).indexOf(String.valueOf(wob.getUpgradeLevel())));
            ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingDeconstructedEvent(wo.getSchematicLocation(), (String)buildingName, wob.getUpgradeLevel()));
        } else {
            this.sendCompletionMessage(wo);
        }
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            ((AbstractJobStructure)this.job).complete();
            if (wo instanceof WorkOrderBuildBuilding) {
                building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getSchematicLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getSchematicLocation()));
                } else {
                    BlockEntity te = this.worker.f_19853_.m_7702_(building.getID());
                    if (te instanceof AbstractTileEntityColonyBuilding && ((IBlueprintDataProvider)te).getSchematicName().isEmpty()) {
                        building.onUpgradeComplete(((WorkOrderBuildBuilding)wo).getUpgradeLevel());
                        building.setBuildingLevel(((WorkOrderBuildBuilding)wo).getUpgradeLevel());
                    }
                }
            } else if (wo instanceof WorkOrderBuildRemoval) {
                building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getSchematicLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getSchematicLocation()));
                } else {
                    building.setDeconstructed();
                }
            }
        }
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).resetNeededResources();
    }

    protected void sendCompletionMessage(WorkOrderBuildDecoration wo) {
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && ((AbstractJobStructure)this.job).getBlueprint() != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint()) {
            ((AbstractJobStructure)this.job).setBlueprint(null);
            if (((AbstractJobStructure)this.job).hasWorkOrder()) {
                ((AbstractJobStructure)this.job).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
            }
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).cancelAllRequestsOfCitizen(this.worker.getCitizenData());
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return true;
        }
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((LevelAccessor)this.world, ((AbstractJobStructure)this.job).getWorkOrder().getSchematicLocation()) && this.getState() != AIWorkerState.PICK_UP_RESIDUALS;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        int hashCode = stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.m_41778_() + "-" + hashCode);
        if (resource == null) {
            this.requestMaterials();
            resource = buildingWorker.getNeededResources().get(stack.m_41778_() + "-" + hashCode);
        }
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = new ItemStack((ItemLike)resource.getItem(), Math.min(64, resource.getAmount()));
        resStack.m_41751_(resource.getItemStack().m_41783_());
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }

    protected static enum RequestStage {
        SOLID,
        DECO,
        ENTITIES;

    }
}

