/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.CustomArrowEntity;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.IItemHandler;

public class RangerCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus ARCHER_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_combat.png"), "com.minecolonies.gui.visiblestatus.archer_combat");
    private final AbstractEntityAIGuard parentAI;
    private static final double COMBAT_SPEED = 1.0;
    private static final double ARROW_EXTRA_DAMAGE = 2.0;
    private static final int BOW_HOLDING_DELAY = 10;
    private static final int GUARD_BONUS_RANGE = 10;
    private static final int FLEE_CHANCE = 3;
    private final PathingOptions combatPathingOptions;

    public RangerCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(0.9);
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), ToolType.BOW, 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxToolLevel());
        if (weaponSlot != -1) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, weaponSlot);
            if (this.nextAttackTime - 10L >= ((EntityCitizen)this.user).f_19853_.m_46467_()) {
                ((EntityCitizen)this.user).m_6672_(InteractionHand.MAIN_HAND);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        if (((EntityCitizen)this.user).m_20280_((Entity)target) < 7.0) {
            if (((EntityCitizen)this.user).m_21187_().nextInt(3) == 0 && !((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
                ((EntityCitizen)this.user).getNavigation().moveAwayFromLivingEntity((Entity)target, this.getAttackDistance() / 2.0, this.getCombatMovementSpeed());
            }
        } else {
            ((EntityCitizen)this.user).getNavigation().m_26573_();
        }
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(ARCHER_COMBAT);
        ((EntityCitizen)this.user).m_6674_(InteractionHand.MAIN_HAND);
        int amountOfArrows = 1;
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS) > 0.0 && ((EntityCitizen)this.user).m_21187_().nextDouble() < ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS)) {
            ++amountOfArrows;
        }
        for (int i = 0; i < amountOfArrows; ++i) {
            int k;
            ItemStack bow;
            AbstractArrow arrow = CombatUtils.createArrowForShooter((LivingEntity)this.user);
            if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARROW_PIERCE) > 0.0) {
                arrow.m_36767_((byte)2);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)(bow = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND))) > 0) {
                arrow.m_20254_(100);
            }
            if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bow)) > 0) {
                arrow.m_36735_(k);
            }
            double damage = this.calculateDamage(arrow);
            arrow.m_36781_(damage);
            float chance = 15.0f / (float)(((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) + 1);
            CombatUtils.shootArrow(arrow, target, chance);
            ((EntityCitizen)this.user).m_5496_(SoundEvents.f_12382_, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).m_21187_()));
        }
        target.m_6703_((LivingEntity)this.user);
        ((EntityCitizen)this.user).getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
        ((EntityCitizen)this.user).m_5810_();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
    }

    @Override
    protected double getAttackDistance() {
        int attackDist = 10;
        if (((EntityCitizen)this.user).getCitizenData().getWorkBuilding() != null) {
            attackDist += ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel();
        }
        if (((EntityCitizen)this.user).getCitizenData() != null) {
            attackDist = (int)((float)attackDist + (float)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 50.0f * 15.0f);
        }
        attackDist = Math.min(attackDist, 24);
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (((EntityCitizen)this.user).m_20186_() - this.target.m_20186_()));
        }
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            attackDist += 10;
        }
        return attackDist;
    }

    @Override
    protected int getAttackDelay() {
        int attackDelay = 60 - ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability);
        return Math.max(attackDelay, 20);
    }

    private double calculateDamage(AbstractArrow arrow) {
        int slot;
        int damage = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) / 5;
        ItemStack heldItem = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        damage = (int)((double)damage + (double)EnchantmentHelper.m_44833_((ItemStack)heldItem, (MobType)this.target.m_6336_()) / 2.5);
        damage += EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)heldItem);
        damage = (int)((double)damage + ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_DAMAGE));
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0 && (slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.m_41720_() instanceof ArrowItem)) != -1 && !ItemStackUtils.isEmpty(((EntityCitizen)this.user).getInventoryCitizen().extractItem(slot, 1, true)).booleanValue()) {
            damage = (int)((double)damage + 2.0);
            ((CustomArrowEntity)arrow).setOnHitCallback(entityRayTraceResult -> {
                int arrowSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.m_41720_() instanceof ArrowItem);
                if (arrowSlot != -1) {
                    ((EntityCitizen)this.user).getInventoryCitizen().extractItem(arrowSlot, 1, false);
                }
                return true;
            });
        }
        if ((double)((EntityCitizen)this.user).m_21223_() <= (double)((EntityCitizen)this.user).m_21233_() * 0.2) {
            damage *= 2;
        }
        return (double)(2 + damage) * (Double)MineColonies.getConfig().getServer().rangerDamageMult.get();
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            PathJobCanSee job = new PathJobCanSee((LivingEntity)this.user, target, ((EntityCitizen)this.user).f_19853_, ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos(), 40);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).f_19853_, AbstractPathJob.prepareStart((LivingEntity)this.user), target.m_142538_(), 200, (LivingEntity)this.user);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed(), true);
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() * 2 - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.m_142538_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).m_21574_().m_148306_((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getYSearchRange() {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            return 28;
        }
        return 3;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

