/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.healer;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobHealer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.healer.Patient;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.StreamParticleEffectMessage;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkHealer
extends AbstractEntityAIInteract<JobHealer, BuildingHospital> {
    private static final double BASE_XP_GAIN = 2.0;
    private static final int REQUEST_COUNT = 16;
    private Patient currentPatient = null;
    private int progressTicks = 0;
    private static final int MAX_PROGRESS_TICKS = 30;
    private ICitizenData remotePatient;
    private Player playerToHeal;

    public EntityAIWorkHealer(@NotNull JobHealer job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 1), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.CURE, this::cure, 20), new AITarget((IAIState)AIWorkerState.FREE_CURE, this::freeCure, 20), new AITarget((IAIState)AIWorkerState.CURE_PLAYER, this::curePlayer, 20), new AITarget((IAIState)AIWorkerState.REQUEST_CURE, this::requestCure, 20), new AITarget((IAIState)AIWorkerState.WANDER, this::wander, 20));
        this.worker.m_21553_(true);
    }

    private IAIState decide() {
        if (this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        BuildingHospital hospital = (BuildingHospital)this.getOwnBuilding();
        for (AbstractEntityCitizen citizen : WorldUtil.getEntitiesWithinBuilding(this.world, AbstractEntityCitizen.class, this.getOwnBuilding(), cit -> cit.getCitizenDiseaseHandler().isSick())) {
            hospital.checkOrCreatePatientFile(citizen.getCivilianID());
        }
        for (Patient patient : hospital.getPatients()) {
            Disease disease;
            ICitizenData data = hospital.getColony().getCitizenManager().getCivilian(patient.getId());
            if (data == null || !data.getEntity().isPresent() || data.getEntity().isPresent() && !data.getEntity().get().getCitizenDiseaseHandler().isSick()) {
                hospital.removePatientFile(patient);
                continue;
            }
            EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
            String diseaseName = citizen.getCitizenDiseaseHandler().getDisease();
            Disease disease2 = disease = diseaseName.isEmpty() ? null : IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName);
            if (patient.getState() == Patient.PatientState.NEW) {
                this.currentPatient = patient;
                return AIWorkerState.REQUEST_CURE;
            }
            if (patient.getState() == Patient.PatientState.REQUESTED) {
                if (disease == null) {
                    this.currentPatient = patient;
                    return AIWorkerState.CURE;
                }
                if (this.testRandomCureChance()) {
                    this.currentPatient = patient;
                    return AIWorkerState.FREE_CURE;
                }
                if (!InventoryUtils.isItemHandlerFull((IItemHandler)citizen.getInventoryCitizen())) {
                    if (this.hasCureInInventory(disease, (IItemHandler)this.worker.getInventoryCitizen()) || this.hasCureInInventory(disease, (IItemHandler)((BuildingHospital)this.getOwnBuilding()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null))) {
                        this.currentPatient = patient;
                        return AIWorkerState.CURE;
                    }
                    ImmutableList list = ((BuildingHospital)this.getOwnBuilding()).getOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class));
                    ImmutableList completed = ((BuildingHospital)this.getOwnBuilding()).getCompletedRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Stack.class));
                    for (ItemStack cure : IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName).getCure()) {
                        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), arg_0 -> ((ItemStack)cure).m_41656_(arg_0))) continue;
                        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)((BuildingHospital)this.getOwnBuilding()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), stack -> stack.m_41656_(cure)) >= cure.m_41613_()) {
                            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> stack.m_41656_(cure), cure.m_41613_());
                            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                        }
                        boolean hasCureRequested = false;
                        for (IRequest request : list) {
                            if (!((Stack)request.getRequest()).getStack().m_41656_(cure)) continue;
                            hasCureRequested = true;
                            break;
                        }
                        for (IRequest request : completed) {
                            if (!((Stack)request.getRequest()).getStack().m_41656_(cure)) continue;
                            hasCureRequested = true;
                            break;
                        }
                        if (hasCureRequested) continue;
                        patient.setState(Patient.PatientState.NEW);
                        break;
                    }
                } else {
                    data.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.healer.fullinv"), ChatPriority.BLOCKING));
                }
            }
            if (patient.getState() != Patient.PatientState.TREATED) continue;
            if (disease == null) {
                this.currentPatient = patient;
                return AIWorkerState.CURE;
            }
            if (this.hasCureInInventory(disease, (IItemHandler)citizen.getInventoryCitizen())) continue;
            patient.setState(Patient.PatientState.NEW);
            return AIWorkerState.DECIDE;
        }
        Iterator<Object> iterator = WorldUtil.getEntitiesWithinBuilding(this.world, Player.class, this.getOwnBuilding(), player -> player.m_21223_() < player.m_21233_() - 10.0f - (float)(2 * ((BuildingHospital)this.getOwnBuilding()).getBuildingLevel())).iterator();
        if (iterator.hasNext()) {
            Player player2;
            this.playerToHeal = player2 = (Player)iterator.next();
            return AIWorkerState.CURE_PLAYER;
        }
        ICitizenData data = ((BuildingHospital)this.getOwnBuilding()).getColony().getCitizenManager().getRandomCitizen();
        if (data.getEntity().isPresent() && (double)data.getEntity().get().m_21223_() < 10.0 && BlockPosUtil.getDistance2D(data.getEntity().get().m_142538_(), ((BuildingHospital)this.getOwnBuilding()).getPosition()) < (long)(((BuildingHospital)this.getOwnBuilding()).getBuildingLevel() * 40)) {
            this.remotePatient = data;
            return AIWorkerState.WANDER;
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState requestCure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.getOwnBuilding()).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (this.walkToBlock(citizen.m_142538_())) {
            return AIWorkerState.REQUEST_CURE;
        }
        String diseaseName = citizen.getCitizenDiseaseHandler().getDisease();
        if (diseaseName.isEmpty()) {
            this.currentPatient.setState(Patient.PatientState.REQUESTED);
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        ImmutableList list = ((BuildingHospital)this.getOwnBuilding()).getOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class));
        ImmutableList completed = ((BuildingHospital)this.getOwnBuilding()).getCompletedRequestsOfType(this.worker.getCitizenData(), TypeToken.of(Stack.class));
        for (ItemStack cure : IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName).getCure()) {
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), arg_0 -> ((ItemStack)cure).m_41656_(arg_0))) continue;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)((BuildingHospital)this.getOwnBuilding()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), arg_0 -> ((ItemStack)cure).m_41656_(arg_0))) continue;
            boolean hasRequest = false;
            for (IRequest request : list) {
                if (!((Stack)request.getRequest()).getStack().m_41656_(cure)) continue;
                hasRequest = true;
                break;
            }
            for (IRequest request : completed) {
                if (!((Stack)request.getRequest()).getStack().m_41656_(cure)) continue;
                hasRequest = true;
                break;
            }
            if (hasRequest) continue;
            this.worker.getCitizenData().createRequestAsync(new Stack(cure, 16, 1));
        }
        this.currentPatient.setState(Patient.PatientState.REQUESTED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState cure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.getOwnBuilding()).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (this.walkToBlock(data.getEntity().get().m_142538_())) {
            return AIWorkerState.CURE;
        }
        String diseaseName = citizen.getCitizenDiseaseHandler().getDisease();
        Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName);
        if (diseaseName.isEmpty()) {
            this.currentPatient = null;
            citizen.m_5634_(10.0f);
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            citizen.markDirty();
            return AIWorkerState.DECIDE;
        }
        if (!this.hasCureInInventory(disease, (IItemHandler)this.worker.getInventoryCitizen())) {
            if (this.hasCureInInventory(disease, (IItemHandler)((BuildingHospital)this.getOwnBuilding()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null))) {
                for (ItemStack cure : disease.getCure()) {
                    if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack.m_41656_(cure)) >= cure.m_41613_()) continue;
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> stack.m_41656_(cure), 1);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
            }
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        if (!this.hasCureInInventory(disease, (IItemHandler)citizen.getInventoryCitizen())) {
            for (ItemStack cure : disease.getCure()) {
                if (InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventoryCitizen(), stack -> stack.m_41656_(cure)) >= cure.m_41613_()) continue;
                if (InventoryUtils.isItemHandlerFull((IItemHandler)citizen.getInventoryCitizen())) {
                    data.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.healer.fullinv"), ChatPriority.BLOCKING));
                    this.currentPatient = null;
                    return AIWorkerState.DECIDE;
                }
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), arg_0 -> ((ItemStack)cure).m_41656_(arg_0), cure.m_41613_(), (IItemHandler)citizen.getInventoryCitizen());
            }
        }
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.currentPatient.setState(Patient.PatientState.TREATED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState freeCure() {
        if (this.currentPatient == null) {
            return AIWorkerState.DECIDE;
        }
        ICitizenData data = ((BuildingHospital)this.getOwnBuilding()).getColony().getCitizenManager().getCivilian(this.currentPatient.getId());
        if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenDiseaseHandler().isSick()) {
            this.currentPatient = null;
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)data.getEntity().get();
        if (this.walkToBlock(citizen.m_142538_())) {
            this.progressTicks = 0;
            return AIWorkerState.FREE_CURE;
        }
        ++this.progressTicks;
        if (this.progressTicks < 30) {
            Network.getNetwork().sendToTrackingEntity(new StreamParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 2.0, 0.0), citizen.m_20182_(), ParticleTypes.f_123750_, this.progressTicks % 30, 30), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 2.0, 0.0), ParticleTypes.f_123750_, this.progressTicks), (Entity)this.worker);
            return this.getState();
        }
        this.progressTicks = 0;
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        citizen.getCitizenDiseaseHandler().cure();
        this.currentPatient.setState(Patient.PatientState.TREATED);
        this.currentPatient = null;
        return AIWorkerState.DECIDE;
    }

    private IAIState curePlayer() {
        if (this.playerToHeal == null) {
            return AIWorkerState.DECIDE;
        }
        if (this.walkToBlock(new BlockPos(this.playerToHeal.m_20182_()))) {
            return this.getState();
        }
        this.playerToHeal.m_5634_(this.playerToHeal.m_21233_() - this.playerToHeal.m_21223_() - 5.0f - (float)((BuildingHospital)this.getOwnBuilding()).getBuildingLevel());
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.DECIDE;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.CURE;
    }

    private IAIState wander() {
        if (this.remotePatient == null || !this.remotePatient.getEntity().isPresent()) {
            return AIWorkerState.DECIDE;
        }
        EntityCitizen citizen = (EntityCitizen)this.remotePatient.getEntity().get();
        if (this.walkToBlock(this.remotePatient.getEntity().get().m_142538_())) {
            return this.getState();
        }
        Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.remotePatient.getEntity().get().m_20182_(), ParticleTypes.f_123750_, 1), (Entity)this.worker);
        citizen.m_5634_(citizen.m_21233_() - citizen.m_21223_() - 5.0f - (float)((BuildingHospital)this.getOwnBuilding()).getBuildingLevel());
        citizen.markDirty();
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        this.remotePatient = null;
        return AIWorkerState.START_WORKING;
    }

    private boolean testRandomCureChance() {
        return this.worker.m_21187_().nextInt(3600) <= Math.max(1, this.getSecondarySkillLevel() / 20);
    }

    private boolean hasCureInInventory(Disease disease, IItemHandler handler) {
        for (ItemStack cure : disease.getCure()) {
            if (InventoryUtils.getItemCountInItemHandler(handler, stack -> stack.m_41656_(cure)) >= cure.m_41613_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<BuildingHospital> getExpectedBuildingClass() {
        return BuildingHospital.class;
    }
}

