/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.planter;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.coremod.colony.jobs.JobPlanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPlanter
extends AbstractEntityAICrafting<JobPlanter, BuildingPlantation> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final Integer PLANT_TO_REQUEST = 16;
    private static final double XP_PER_HARVEST = 1.0;
    private BlockPos workPos;

    public EntityAIWorkPlanter(@NotNull JobPlanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.PLANTATION_FARM, this::farm, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_PLANT, this::plant, 20));
        this.worker.m_21553_(true);
    }

    private IAIState plant() {
        if (this.workPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.workPos.m_7494_())) {
            return this.getState();
        }
        ItemStack currentStack = new ItemStack((ItemLike)((BuildingPlantation)this.getOwnBuilding()).nextPlantPhase());
        int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(currentStack));
        if (plantInInv <= 0) {
            return AIWorkerState.START_WORKING;
        }
        if (this.world.m_46597_(this.workPos.m_7494_(), BlockUtils.getBlockStateFromStack((ItemStack)currentStack))) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), currentStack);
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState farm() {
        if (this.workPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.workPos.m_7494_())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.m_8055_(this.workPos.m_7494_()), this.workPos.m_7494_())) {
            return AIWorkerState.START_WORKING;
        }
        if (!(this.world.m_8055_(this.workPos.m_7494_()).m_60734_() instanceof AirBlock)) {
            this.mineBlock(this.workPos.m_7494_());
            return this.getState();
        }
        for (ItemEntity item : this.world.m_45976_(ItemEntity.class, new AABB(this.worker.m_142538_()).m_82363_(4.0, 1.0, 4.0).m_82363_(-4.0, -1.0, -4.0))) {
            if (item == null) continue;
            this.worker.getCitizenItemHandler().tryPickupItemEntity(item);
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    public Class<BuildingPlantation> getExpectedBuildingClass() {
        return BuildingPlantation.class;
    }

    @Override
    protected IAIState decide() {
        int plantInInv;
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING && nextState != AIWorkerState.IDLE) {
            return nextState;
        }
        BuildingPlantation plantation = (BuildingPlantation)this.getOwnBuilding();
        List<BlockPos> list = plantation.getPosForPhase();
        for (BlockPos pos : list) {
            if (!this.isAtLeastThreeHigh(pos)) continue;
            this.workPos = pos;
            return AIWorkerState.PLANTATION_FARM;
        }
        Item current = plantation.nextPlantPhase();
        int plantInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> itemStack.m_41656_(new ItemStack((ItemLike)current)));
        if (plantInBuilding + (plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41656_(new ItemStack((ItemLike)current)))) <= 0) {
            this.requestPlantable(current);
            return AIWorkerState.START_WORKING;
        }
        if (plantInInv == 0 && plantInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> itemStack.m_41656_(new ItemStack((ItemLike)current)), Math.min(plantInBuilding, PLANT_TO_REQUEST));
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        for (BlockPos pos : list) {
            if (!(this.world.m_8055_(pos.m_7494_()).m_60734_() instanceof AirBlock)) continue;
            this.workPos = pos;
            return AIWorkerState.PLANTATION_PLANT;
        }
        return AIWorkerState.START_WORKING;
    }

    private void requestPlantable(Item current) {
        if (!((BuildingPlantation)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().m_41720_() == current)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)current, PLANT_TO_REQUEST.intValue())));
        }
    }

    private boolean isAtLeastThreeHigh(BlockPos pos) {
        return !(this.world.m_8055_(pos.m_6630_(1)).m_60734_() instanceof AirBlock) && !(this.world.m_8055_(pos.m_6630_(2)).m_60734_() instanceof AirBlock) && !(this.world.m_8055_(pos.m_6630_(3)).m_60734_() instanceof AirBlock);
    }
}

