/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.combat;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class CombatUtils {
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.4;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public static AbstractArrow createArrowForShooter(LivingEntity shooter) {
        AbstractArrow arrowEntity = (AbstractArrow)ModEntities.MC_NORMAL_ARROW.m_20615_(shooter.f_19853_);
        arrowEntity.m_5602_((Entity)shooter);
        ItemStack bow = shooter.m_21120_(InteractionHand.MAIN_HAND);
        if (bow.m_41720_() instanceof BowItem) {
            arrowEntity = ((BowItem)bow.m_41720_()).customArrow(arrowEntity);
        }
        arrowEntity.m_6034_(shooter.m_20185_(), shooter.m_20186_() + 1.0, shooter.m_20189_());
        return arrowEntity;
    }

    public static void shootArrow(AbstractArrow arrow, LivingEntity target, float hitChance) {
        double xVector = target.m_20185_() - arrow.m_20185_();
        double yVector = target.m_142469_().f_82289_ + (double)target.m_20206_() / 2.0 - arrow.m_20186_();
        double zVector = target.m_20189_() - arrow.m_20189_();
        double distance = Mth.m_14116_((float)((float)(xVector * xVector + zVector * zVector)));
        double dist3d = Mth.m_14116_((float)((float)(yVector * yVector + xVector * xVector + zVector * zVector)));
        arrow.m_6686_(xVector, yVector + distance * 0.18, zVector, (float)(1.4 + dist3d / 35.0), hitChance);
        target.f_19853_.m_7967_((Entity)arrow);
    }

    public static void notifyGuardsOfTarget(AbstractEntityCitizen user, LivingEntity target, int callRange) {
        for (ICitizenData iCitizenData : user.getCitizenData().getWorkBuilding().getAllAssignedCitizen()) {
            if (!iCitizenData.getEntity().isPresent() || iCitizenData.getEntity().get().m_142581_() != null) continue;
            ((EntityCitizen)iCitizenData.getEntity().get()).getThreatTable().addThreat(target, 0);
        }
        if (target instanceof AbstractEntityMinecoloniesMob) {
            for (Map.Entry entry : user.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().entrySet()) {
                if (!(entry.getValue() instanceof AbstractBuildingGuards) || !(user.m_142538_().m_123331_((Vec3i)entry.getKey()) < (double)callRange)) continue;
                AbstractBuildingGuards building = (AbstractBuildingGuards)entry.getValue();
                building.setTempNextPatrolPoint(target.m_142538_());
            }
        }
    }
}

