/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class EntityAIEatTask
extends Goal {
    private static final int MINUTES_WAITING_TIME = 2;
    private static final int MIN_DISTANCE_TO_RESTAURANT = 3;
    private static final int REQUIRED_TIME_TO_EAT = 5;
    private static final int GET_YOURSELF_SATURATION = 30;
    private static final double RESTAURANT_LIMIT = 2.5;
    private static final int MINUTES_BETWEEN_FOOD_CHECKS = 5;
    private final EntityCitizen citizen;
    private final TickRateStateMachine<EatingState> stateMachine;
    private int waitingTicks = 0;
    private int foodSlot = -1;
    private BlockPos eatPos = null;
    private BlockPos restaurantPos;
    private int timeOutWalking = 0;

    public EntityAIEatTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<EatingState>(EatingState.IDLE, e -> Log.getLogger().warn("Eating AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.IDLE, this::shouldEat, () -> EatingState.CHECK_FOR_FOOD, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.CHECK_FOR_FOOD, () -> true, this::getFood, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_HUT, () -> true, this::goToHut, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.EAT, () -> true, this::eat, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.SEARCH_RESTAURANT, () -> true, this::searchRestaurant, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_RESTAURANT, () -> true, this::goToRestaurant, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.WAIT_FOR_FOOD, () -> true, this::waitForFood, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GO_TO_EAT_POS, () -> true, this::goToEatingPlace, 20));
        this.stateMachine.addTransition(new TickingTransition<EatingState>(EatingState.GET_FOOD_YOURSELF, () -> true, this::getFoodYourself, 20));
    }

    private EatingState getFood() {
        if (this.hasFood()) {
            return EatingState.EAT;
        }
        return EatingState.GO_TO_HUT;
    }

    public boolean shouldEat() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        if (this.citizen.getCitizenDiseaseHandler().isSick() && this.citizen.getCitizenSleepHandler().isAsleep()) {
            return false;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null || !this.citizen.isOkayToEat()) {
            return false;
        }
        if (citizenData.getSaturation() <= 10.0) {
            if (citizenData.getSaturation() <= 2.5 || citizenData.getSaturation() < 6.0 && (double)this.citizen.m_21223_() < 6.0) {
                return true;
            }
            ++this.waitingTicks;
            if (this.waitingTicks >= 300 || citizenData.getWorkBuilding() == null) {
                this.waitingTicks = 0;
                return true;
            }
        }
        return false;
    }

    public boolean m_8036_() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        this.stateMachine.tick();
        return this.stateMachine.getState() != EatingState.IDLE;
    }

    public void m_8037_() {
        this.stateMachine.tick();
    }

    private boolean canEat(ICitizenData citizenData, ItemStack stack) {
        return citizenData.getWorkBuilding() == null || citizenData.getWorkBuilding().canEat(stack);
    }

    private EatingState eat() {
        IColony citizenColony;
        if (!this.hasFood()) {
            return EatingState.CHECK_FOR_FOOD;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        ItemStack stack = citizenData.getInventory().getStackInSlot(this.foodSlot);
        if (!ItemStackUtils.CAN_EAT.test(stack) || !this.canEat(citizenData, stack)) {
            return EatingState.CHECK_FOR_FOOD;
        }
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, stack);
        this.citizen.m_6674_(InteractionHand.MAIN_HAND);
        this.citizen.m_5496_(SoundEvents.f_11912_, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.m_21187_()));
        Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(this.citizen.m_21205_(), this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), this.citizen.m_146909_(), this.citizen.m_146908_(), this.citizen.m_20192_()), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 5) {
            return EatingState.EAT;
        }
        FoodProperties itemFood = stack.m_41720_().m_41473_();
        Item containerItem = stack.m_41720_().m_41469_();
        if (containerItem == null && stack.m_41720_() instanceof BowlFoodItem) {
            containerItem = Items.f_42399_;
        }
        double satIncrease = (double)itemFood.m_38744_() * (1.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
        citizenData.increaseSaturation(satIncrease / 2.0);
        citizenData.getInventory().extractItem(this.foodSlot, 1, false);
        if (containerItem != null && !(containerItem instanceof AirItem)) {
            if (citizenData.getInventory().isFull()) {
                InventoryUtils.spawnItemStack(this.citizen.f_19853_, this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), new ItemStack((ItemLike)containerItem, 1));
            } else {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)citizenData.getInventory(), new ItemStack((ItemLike)containerItem, 1));
            }
        }
        if ((citizenColony = this.citizen.getCitizenColonyHandler().getColony()) != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(citizenColony, playerMP -> AdvancementTriggers.CITIZEN_EAT_FOOD.trigger((ServerPlayer)playerMP, stack));
        }
        citizenData.markDirty();
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (citizenData.getSaturation() < 20.0 && !citizenData.getInventory().getStackInSlot(this.foodSlot).m_41619_()) {
            this.waitingTicks = 0;
            return EatingState.EAT;
        }
        return EatingState.IDLE;
    }

    private EatingState getFoodYourself() {
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        IBuilding cookBuilding = colony.getBuildingManager().getBuilding(this.restaurantPos);
        if (cookBuilding instanceof BuildingCook) {
            InventoryUtils.transferFoodUpToSaturation(cookBuilding, (IItemHandler)this.citizen.getInventoryCitizen(), 30, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack) && !((BuildingCook)cookBuilding).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food")).isItemInList(new ItemStorage((ItemStack)stack)));
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToEatingPlace() {
        if (this.eatPos == null || this.timeOutWalking++ > 400) {
            if (this.hasFood()) {
                this.timeOutWalking = 0;
                return EatingState.EAT;
            }
            ++this.waitingTicks;
            if (this.waitingTicks > 120) {
                this.waitingTicks = 0;
                return EatingState.GET_FOOD_YOURSELF;
            }
        }
        if (this.citizen.isWorkerAtSiteWithMove(this.eatPos, 2)) {
            SittingEntity.sitDown(this.eatPos, (Mob)this.citizen, 1200);
            this.timeOutWalking += 10;
            if (!this.hasFood()) {
                ++this.waitingTicks;
                if (this.waitingTicks > 120) {
                    this.waitingTicks = 0;
                    return EatingState.GET_FOOD_YOURSELF;
                }
            }
        }
        return EatingState.GO_TO_EAT_POS;
    }

    private BlockPos findPlaceToEat() {
        IBuilding restaurant;
        if (this.restaurantPos != null && (restaurant = this.citizen.getCitizenData().getColony().getBuildingManager().getBuilding(this.restaurantPos)) instanceof BuildingCook) {
            return ((BuildingCook)restaurant).getNextSittingPosition();
        }
        return null;
    }

    private EatingState waitForFood() {
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        this.restaurantPos = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingCook.class);
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (!colony.getBuildingManager().getBuilding(this.restaurantPos).isInBuilding(this.citizen.m_142538_())) {
            return EatingState.GO_TO_RESTAURANT;
        }
        this.eatPos = this.findPlaceToEat();
        if (this.eatPos != null) {
            return EatingState.GO_TO_EAT_POS;
        }
        if (this.hasFood()) {
            return EatingState.EAT;
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToHut() {
        IBuilding buildingWorker = this.citizen.getCitizenData().getWorkBuilding();
        if (buildingWorker == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (this.citizen.isWorkerAtSiteWithMove(buildingWorker.getPosition(), 3)) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)buildingWorker, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack));
            if (slot != -1 && InventoryUtils.transferFoodUpToSaturation(buildingWorker, (IItemHandler)this.citizen.getInventoryCitizen(), 30, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack))) {
                return EatingState.EAT;
            }
            return EatingState.SEARCH_RESTAURANT;
        }
        return EatingState.GO_TO_HUT;
    }

    private EatingState goToRestaurant() {
        IBuilding building;
        if (this.restaurantPos != null && (building = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(this.restaurantPos)) != null) {
            if (building.isInBuilding(this.citizen.m_142538_())) {
                return EatingState.WAIT_FOR_FOOD;
            }
            if (!this.citizen.isWorkerAtSiteWithMove(this.restaurantPos, 3)) {
                return EatingState.GO_TO_RESTAURANT;
            }
        }
        return EatingState.SEARCH_RESTAURANT;
    }

    private EatingState searchRestaurant() {
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        this.restaurantPos = citizenData.getWorkBuilding() != null ? colony.getBuildingManager().getBestBuilding(citizenData.getWorkBuilding().getPosition(), BuildingCook.class) : (citizenData.getHomeBuilding() != null ? colony.getBuildingManager().getBestBuilding(citizenData.getHomeBuilding().getPosition(), BuildingCook.class) : colony.getBuildingManager().getBestBuilding(this.citizen, BuildingCook.class));
        IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
        if (job != null && citizenData.isWorking()) {
            citizenData.setWorking(false);
        }
        if (this.restaurantPos == null) {
            citizenData.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.ai.norestaurant"), ChatPriority.BLOCKING));
            return EatingState.CHECK_FOR_FOOD;
        }
        return EatingState.GO_TO_RESTAURANT;
    }

    private boolean hasFood() {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat(this.citizen.getCitizenData(), (ItemStack)stack));
        if (slot != -1) {
            this.foodSlot = slot;
            return true;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.citizen.getInventoryCitizen(), ItemStackUtils.ISCOOKABLE)) {
            citizenData.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.ai.wrongfood"), ChatPriority.PENDING));
        } else if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.citizen.getInventoryCitizen(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && !this.canEat(citizenData, (ItemStack)stack))) {
            if (citizenData.isChild()) {
                citizenData.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.ai.betterfood.children"), ChatPriority.BLOCKING));
            } else {
                citizenData.triggerInteraction(new StandardInteraction((Component)new TranslatableComponent("com.minecolonies.coremod.ai.betterfood"), ChatPriority.BLOCKING));
            }
        }
        return false;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.foodSlot = -1;
        this.citizen.m_21253_();
        this.citizen.m_5810_();
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.restaurantPos = null;
        this.eatPos = null;
    }

    public void m_8041_() {
        this.reset();
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    public void m_8056_() {
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.EAT);
    }

    public static enum EatingState implements IState
    {
        IDLE,
        CHECK_FOR_FOOD,
        GO_TO_HUT,
        SEARCH_RESTAURANT,
        GO_TO_RESTAURANT,
        WAIT_FOR_FOOD,
        GET_FOOD_YOURSELF,
        GO_TO_EAT_POS,
        EAT;

    }
}

