/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class EntityAIMournCitizen
extends Goal {
    private final TickRateStateMachine<MourningState> stateMachine;
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<MourningState>(MourningState.IDLE, e -> Log.getLogger().warn("Mourning AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(this::shouldMourn, () -> MourningState.IDLE, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.IDLE, () -> true, this::decide, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDERING, () -> true, this::wander, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.STARING, () -> true, this::stare, 20));
    }

    private boolean shouldMourn() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.MOURN && this.citizen.m_21187_().nextInt(300) < 1) {
            this.citizen.getCitizenData().getCitizenMournHandler().clearDeceasedCitizen();
            this.citizen.getCitizenData().getCitizenMournHandler().setMourning(false);
            this.citizen.getCitizenData().setVisibleStatus(null);
            return true;
        }
        return false;
    }

    private MourningState walkToTownHall() {
        BlockPos pos = this.getMournLocation();
        this.citizen.getNavigation().moveToXYZ(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.speed);
        return MourningState.IDLE;
    }

    private MourningState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return MourningState.IDLE;
    }

    private MourningState stare() {
        if (this.citizen.m_21187_().nextInt(200) < 1) {
            this.closestEntity = null;
            return MourningState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.f_19853_.m_45963_(EntityCitizen.class, TargetingConditions.f_26872_, (LivingEntity)this.citizen, this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), this.citizen.m_142469_().m_82377_(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return MourningState.IDLE;
            }
        }
        this.citizen.m_21563_().m_24950_(this.closestEntity.m_20185_(), this.closestEntity.m_20186_() + (double)this.closestEntity.m_20192_(), this.closestEntity.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        return MourningState.STARING;
    }

    private MourningState decide() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN) {
            return MourningState.IDLE;
        }
        if (!this.citizen.getNavigation().m_26571_()) {
            return MourningState.IDLE;
        }
        if (this.citizen.getCitizenStatusHandler().getStatus() != Status.MOURN) {
            this.citizen.getCitizenItemHandler().removeHeldItem();
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.MOURNING);
            this.citizen.getCitizenStatusHandler().setStatus(Status.MOURN);
            return MourningState.WALKING_TO_TOWNHALL;
        }
        this.citizen.m_21563_().m_24950_(this.citizen.m_20185_(), this.citizen.m_20186_() - 10.0, this.citizen.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        if (BlockPosUtil.getDistance2D(this.citizen.m_142538_(), this.getMournLocation()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        if (this.citizen.m_21187_().nextBoolean()) {
            return MourningState.STARING;
        }
        return MourningState.WANDERING;
    }

    public boolean m_8036_() {
        this.stateMachine.tick();
        return this.stateMachine.getState() != MourningState.IDLE;
    }

    public void m_8037_() {
        this.stateMachine.tick();
    }

    public void m_8041_() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    protected BlockPos getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return this.citizen.m_21534_();
        }
        return colony.getBuildingManager().getTownHall().getPosition();
    }

    public static enum MourningState implements IState
    {
        IDLE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING;

    }
}

