/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.registry.IMobAIRegistry;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.aitasks.EntityAIBreakDoor;
import com.minecolonies.coremod.entity.mobs.aitasks.RaiderMeleeAI;
import com.minecolonies.coremod.entity.mobs.aitasks.RaiderRangedAI;
import com.minecolonies.coremod.entity.mobs.aitasks.RaiderWalkAI;
import com.minecolonies.coremod.util.MultimapCollector;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MobAIRegistry
implements IMobAIRegistry {
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMob, Goal>> mobAiTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMob, Goal>> mobAiTargetTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMob, IStateAI>> mobStateAITasks = Lists.newArrayList();

    public MobAIRegistry() {
        MobAIRegistry.setupMobAiTasks(this);
    }

    private static void setupMobAiTasks(IMobAIRegistry registry) {
        registry.registerNewAiTaskForMobs(0, FloatGoal::new).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIInteractToggleAble((Mob)mob, EntityAIInteractToggleAble.FENCE_TOGGLE)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIBreakDoor((Mob)mob)).registerNewAiTaskForMobs(5, mob -> new LookAtPlayerGoal((Mob)mob, Player.class, 8.0f)).registerNewAiTaskForMobs(6, mob -> new LookAtPlayerGoal((Mob)mob, EntityCitizen.class, 8.0f)).registerNewStateAI(mob -> new RaiderMeleeAI<AbstractEntityMinecoloniesMob>((AbstractEntityMinecoloniesMob)mob, mob.getAI()), mob -> !(mob instanceof IArcherMobEntity)).registerNewStateAI(mob -> new RaiderRangedAI<AbstractEntityMinecoloniesMob>((AbstractEntityMinecoloniesMob)mob, mob.getAI()), mob -> mob instanceof IArcherMobEntity).registerNewStateAI(mob -> new RaiderWalkAI((AbstractEntityMinecoloniesMob)mob, mob.getAI()), mob -> true);
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTasksForMobs(AbstractEntityMinecoloniesMob mob) {
        return (Multimap)this.mobAiTasks.stream().filter(wrapper -> wrapper.entityPredicate.test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMob, Goal> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMob> applyPredicate) {
        this.mobAiTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMob, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewStateAI(Function<AbstractEntityMinecoloniesMob, IStateAI> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMob> applyPredicate) {
        this.mobStateAITasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMob, IStateAI>(0, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public void applyToMob(AbstractEntityMinecoloniesMob mob) {
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMob, IStateAI> taskInformationWrapper : this.mobStateAITasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            taskInformationWrapper.aiTaskProducer.apply(mob);
        }
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMob, IStateAI> taskInformationWrapper : this.mobAiTargetTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.f_21345_.m_25352_(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMob, IStateAI> taskInformationWrapper : this.mobAiTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.f_21345_.m_25352_(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTargetTasksForMobs(AbstractEntityMinecoloniesMob mob) {
        return (Multimap)this.mobAiTargetTasks.stream().filter(wrapper -> wrapper.getEntityPredicate().test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTargetTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMob, Goal> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMob> applyPredicate) {
        this.mobAiTargetTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMob, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    private static final class TaskInformationWrapper<M extends Entity, G> {
        private final int priority;
        private final Function<AbstractEntityMinecoloniesMob, G> aiTaskProducer;
        private final Predicate<M> entityPredicate;

        TaskInformationWrapper(int priority, Function<AbstractEntityMinecoloniesMob, G> aiTaskProducer, Predicate<M> entityPredicate) {
            this.priority = priority;
            this.aiTaskProducer = aiTaskProducer;
            this.entityPredicate = entityPredicate;
        }

        public int getPriority() {
            return this.priority;
        }

        public Function<AbstractEntityMinecoloniesMob, G> getAiTaskProducer() {
            return this.aiTaskProducer;
        }

        public Predicate<M> getEntityPredicate() {
            return this.entityPredicate;
        }
    }
}

