/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.CustomArrowEntity;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class RaiderRangedAI<T extends AbstractEntityMinecoloniesMob>
extends AttackMoveAI<T> {
    private static final int MAX_ATTACK_DELAY = 60;
    private static final int MIN_ATTACK_DELAY = 20;
    private static final double ARROW_PIERCE_DIFFICULTY = 3.0;
    private static final double COMBAT_MOVEMENT_SPEED = 1.1;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private int flightCounter = 0;

    public RaiderRangedAI(T owner, ITickRateStateMachine<IState> stateMachine) {
        super(owner, stateMachine);
    }

    @Override
    protected boolean isInDistanceForAttack(LivingEntity target) {
        this.flightCounter = EntityUtils.isFlying(target) ? ++this.flightCounter : 0;
        if (this.flightCounter > 5) {
            return true;
        }
        return super.isInAttackDistance(target);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        ((AbstractEntityMinecoloniesMob)this.user).getNavigation().m_26573_();
        AbstractArrow arrowEntity = CombatUtils.createArrowForShooter((LivingEntity)this.user);
        arrowEntity.m_36781_(((AbstractEntityMinecoloniesMob)this.user).m_21051_(RaiderMobUtils.MOB_ATTACK_DAMAGE).m_22135_());
        if (this.flightCounter > 5) {
            ((CustomArrowEntity)arrowEntity).setPlayerArmorPierce();
            arrowEntity.m_20254_(200);
            arrowEntity.m_36781_(10.0);
        }
        if (((AbstractEntityMinecoloniesMob)this.user).getDifficulty() > 3.0) {
            arrowEntity.m_36767_((byte)2);
        }
        CombatUtils.shootArrow(arrowEntity, target, 10.0f);
        ((AbstractEntityMinecoloniesMob)this.user).m_6674_(InteractionHand.MAIN_HAND);
        ((AbstractEntityMinecoloniesMob)this.user).m_5496_(SoundEvents.f_12382_, 1.0f, (float)this.getRandomPitch());
    }

    private double getRandomPitch() {
        return 1.0 / (((AbstractEntityMinecoloniesMob)this.user).m_21187_().nextDouble() * 0.4 + 0.8);
    }

    @Override
    protected double getAttackDistance() {
        return 20.0 * Math.max(((AbstractEntityMinecoloniesMob)this.user).getDifficulty(), 2.0);
    }

    @Override
    protected int getAttackDelay() {
        if (this.flightCounter > 5) {
            return 10;
        }
        return (int)Math.max(20.0, 60.0 - (double)((Integer)MineColonies.getConfig().getServer().barbarianHordeDifficulty.get() * 4) * ((AbstractEntityMinecoloniesMob)this.user).getDifficulty());
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        return ((AbstractEntityMinecoloniesMob)this.user).getNavigation().moveToXYZ(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.1);
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof EntityCitizen || target instanceof Player && !((Player)target).m_7500_() && !target.m_5833_();
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }
}

