/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.apiimp.initializer.ModTagsInitializer;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.util.FurnaceRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class TagWorkAroundEventHandler {
    private static void loadRecipes(@NotNull RecipeManager recipeManager) {
        FurnaceRecipes.getInstance().loadRecipes(recipeManager);
        IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().discover(recipeManager);
    }

    public static class TagFMLEventHandlers {
        @SubscribeEvent
        public static void onServerStarted(@NotNull ServerStartedEvent event) {
            MinecraftServer server = event.getServer();
            TagWorkAroundEventHandler.loadRecipes(server.m_129894_());
            CustomRecipeManager.getInstance().buildLootData(server.m_129898_());
        }
    }

    public static class TagClientEventHandler {
        private static RecipeManager recipeManager;
        private static TagContainer tagManager;

        private static void maybeLoadRecipes() {
            if (recipeManager != null && tagManager != null) {
                if (!Minecraft.m_91087_().m_91091_()) {
                    TagWorkAroundEventHandler.loadRecipes(recipeManager);
                }
                recipeManager = null;
                tagManager = null;
            }
        }

        @SubscribeEvent
        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            recipeManager = event.getRecipeManager();
            TagClientEventHandler.maybeLoadRecipes();
        }

        @SubscribeEvent
        public static void onTagsUpdated(TagsUpdatedEvent event) {
            tagManager = event.getTagManager();
            TagClientEventHandler.maybeLoadRecipes();
        }

        @SubscribeEvent
        public static void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            recipeManager = null;
            tagManager = null;
        }
    }

    public static class TagEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onTagUpdate(TagsUpdatedEvent event) {
            ModTagsInitializer.init(event.getTagManager());
        }

        @SubscribeEvent
        public static void onDataPackSync(OnDatapackSyncEvent event) {
            CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().m_7873_();
                TagWorkAroundEventHandler.loadRecipes(server.m_129894_());
                recipeManager.buildLootData(server.m_129898_());
                for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                    recipeManager.sendCustomRecipeManagerPackets(player);
                }
            } else {
                recipeManager.sendCustomRecipeManagerPackets(event.getPlayer());
            }
        }
    }
}

