/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultSifterCraftingProvider
implements DataProvider {
    private final SifterRecipeProvider recipeProvider;
    private final SifterLootTableProvider lootTableProvider;
    private final Map<Item, List<SifterMeshDetails>> inputs = new HashMap<Item, List<SifterMeshDetails>>();

    public DefaultSifterCraftingProvider(@NotNull DataGenerator generatorIn) {
        this.inputs.put(Items.f_42329_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(71)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(28)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42577_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42578_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41828_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41827_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42799_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42800_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41826_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42577_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42578_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41828_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41827_).m_79707_(5))))));
        this.inputs.put(Items.f_41832_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(85)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(46)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(2))))));
        this.inputs.put(Items.f_41830_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(95)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(2)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(85)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(60)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42533_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42533_).m_79707_(15))))));
        this.inputs.put(Items.f_42049_, Arrays.asList(new SifterMeshDetails(ModItems.sifterMeshString, 1, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(90)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(5)))), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(70)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(10)))), new SifterMeshDetails(ModItems.sifterMeshIron, 4, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.025f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42542_).m_79707_(1)))), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.035f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42542_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42680_).m_79707_(5))))));
        this.recipeProvider = new SifterRecipeProvider(generatorIn);
        this.lootTableProvider = new SifterLootTableProvider(generatorIn);
    }

    @NotNull
    public String m_6055_() {
        return "SifterCraftingProvider";
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.recipeProvider.m_6865_(cache);
        this.lootTableProvider.m_6865_(cache);
    }

    private static class SifterMeshDetails {
        private final String name;
        private final Item mesh;
        private final int minBuildingLevel;
        private final LootTable.Builder lootTable;

        public SifterMeshDetails(@NotNull Item mesh, int minBuildingLevel, @NotNull LootTable.Builder lootTable) {
            this.name = mesh.getRegistryName().m_135815_().replace("sifter_mesh_", "");
            this.mesh = mesh;
            this.minBuildingLevel = minBuildingLevel;
            this.lootTable = lootTable;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Item getMesh() {
            return this.mesh;
        }

        public int getMinBuildingLevel() {
            return this.minBuildingLevel;
        }

        @NotNull
        public LootTable.Builder getLootTable() {
            return this.lootTable;
        }
    }

    private class SifterRecipeProvider
    extends CustomRecipeProvider {
        public SifterRecipeProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        @NotNull
        public String m_6055_() {
            return "SifterRecipeProvider";
        }

        @Override
        protected void registerRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
            for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + inputEntry.getKey().getRegistryName().m_135815_();
                    List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(null, mesh.getLootTable().m_79167_());
                    Stream loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().map(ItemStack::m_41720_));
                    CustomRecipeProvider.CustomRecipeBuilder.create(ModJobs.SIFTER_ID.m_135815_() + "_custom", name).inputs(Stream.of(new ItemStorage(new ItemStack((ItemLike)inputEntry.getKey())), new ItemStorage(new ItemStack((ItemLike)mesh.getMesh()), true, false)).collect(Collectors.toList())).secondaryOutputs(Stream.concat(Stream.of(mesh.getMesh()), loot).map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + name)).minBuildingLevel(mesh.getMinBuildingLevel()).build(consumer);
                }
            }
        }
    }

    private class SifterLootTableProvider
    extends SimpleLootTableProvider {
        public SifterLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @NotNull
        public String m_6055_() {
            return "SifterLootTableProvider";
        }

        @Override
        protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
            for (Map.Entry<Item, List<SifterMeshDetails>> inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + inputEntry.getKey().getRegistryName().m_135815_();
                    registrar.register(new ResourceLocation("minecolonies", "recipes/" + name), LootContextParamSets.f_81420_, mesh.getLootTable());
                }
            }
        }
    }
}

