/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectPlaceMessage
implements IMessage {
    private BlockState state;
    private BlockPos pos;
    private ItemStack stack;

    public DirectPlaceMessage() {
    }

    public DirectPlaceMessage(BlockState state, BlockPos pos, ItemStack stack) {
        this.state = state;
        this.pos = pos;
        this.stack = stack;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.state = Block.m_49803_((int)buf.readInt());
        this.pos = buf.m_130135_();
        this.stack = buf.m_130267_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(Block.m_49956_((BlockState)this.state));
        buf.m_130064_(this.pos);
        buf.m_130055_(this.stack);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        Level world = player.m_20193_();
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos);
        if (colony == null && this.state.m_60734_() == ModBlocks.blockHutTownHall || colony != null && colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            IBuilding building;
            CompoundTag compound = this.stack.m_41783_();
            if (colony != null && compound != null && compound.m_128441_("colony") && colony.getID() != compound.m_128451_("colony")) {
                LanguageHandler.sendPlayerMessage((Player)player, (String)"com.minecolonies.coremod.gui.buildtool.wrongcolony", (Object[])new Object[]{compound.m_128451_("colony")});
                return;
            }
            player.m_20193_().m_46597_(this.pos, this.state);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), this.stack);
            this.state.m_60734_().m_6402_(world, this.pos, this.state, (LivingEntity)player, this.stack);
            if (compound != null && compound.m_128441_("otherLevel") && (building = colony.getBuildingManager().getBuilding(this.pos)) != null) {
                building.setBuildingLevel(compound.m_128451_("otherLevel"));
                building.setDeconstructed();
            }
        }
    }
}

