/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class BuildingHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private HiringMode mode;
    private JobEntry jobId;

    public BuildingHiringModeMessage() {
    }

    public BuildingHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, JobEntry jobId) {
        super(building);
        this.mode = mode;
        this.jobId = jobId;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = HiringMode.values()[buf.readInt()];
        this.jobId = (JobEntry)buf.readRegistryIdSafe(JobEntry.class);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeRegistryId((IForgeRegistryEntry)this.jobId);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobId).setHiringMode(this.mode);
    }
}

