/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private boolean up;
    private String id;

    public ChangeRecipePriorityMessage() {
    }

    public ChangeRecipePriorityMessage(@NotNull IBuildingView building, int location, boolean up, String id) {
        super(building);
        this.recipeLocation = location;
        this.up = up;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
        buf.m_130070_(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        AbstractCraftingBuildingModule module = building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        if (this.up) {
            module.switchOrder(this.recipeLocation, this.recipeLocation - 1);
        } else {
            module.switchOrder(this.recipeLocation, this.recipeLocation + 1);
        }
    }
}

