/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ResearchResearchRequirement
implements IResearchRequirement {
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private final ResourceLocation researchId;
    private final TranslatableComponent researchName;

    public ResearchResearchRequirement(ResourceLocation researchId) {
        this.researchId = researchId;
        this.researchName = new TranslatableComponent("com." + researchId.m_135827_() + ".research." + researchId.m_135815_().replaceAll("[ /]", ".") + ".name");
    }

    public ResearchResearchRequirement(ResourceLocation researchId, TranslatableComponent researchName) {
        this.researchId = researchId;
        this.researchName = researchName;
    }

    public ResearchResearchRequirement(CompoundTag nbt) {
        this.researchId = new ResourceLocation(nbt.m_128461_(TAG_ID));
        this.researchName = new TranslatableComponent(nbt.m_128461_(TAG_NAME));
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.getResearchManager().getResearchTree().hasCompletedResearch(this.researchId);
    }

    @Override
    public TranslatableComponent getDesc() {
        return new TranslatableComponent("com.minecolonies.coremod.research.requirement.research", new Object[]{this.researchName});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return ModResearchRequirements.researchResearchRequirement;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.researchId.toString());
        nbt.m_128359_(TAG_NAME, this.researchName.m_131328_());
        return nbt;
    }
}

