/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.structures;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.structures.MineColoniesStructures;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class EmptyColonyStructure
extends StructureFeature<JigsawConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> STRUCTURE_CREATURES = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 30, 2, 10), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20557_, 30, 2, 10), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20553_, 100, 1, 2));

    public EmptyColonyStructure(Codec<JigsawConfiguration> codec) {
        super(codec, context -> {
            if (!EmptyColonyStructure.isFeatureChunk((PieceGeneratorSupplier.Context<JigsawConfiguration>)context)) {
                return Optional.empty();
            }
            return EmptyColonyStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)context);
        }, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == MineColoniesStructures.EMPTY_COLONY.get()) {
            event.addEntitySpawns(MobCategory.CREATURE, STRUCTURE_CREATURES);
        }
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockPos = context.f_197355_().m_45615_();
        int landHeight = context.f_197352_().m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return topBlock.m_60819_().m_76178_() && landHeight < 200;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        ((JigsawConfiguration)context.f_197356_()).f_67757_ = () -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(new ResourceLocation("minecolonies", "start_pool"));
        ((JigsawConfiguration)context.f_197356_()).f_67758_ = 10;
        Optional structurePiecesGenerator = JigsawPlacement.m_197210_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)true);
        if (structurePiecesGenerator.isPresent()) {
            Log.getLogger().debug("New Empty colony at" + blockpos);
        }
        return structurePiecesGenerator;
    }
}

