/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.structures;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.structures.EmptyColonyStructure;
import com.minecolonies.coremod.structures.MineColoniesConfiguredStructures;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MineColoniesStructures {
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"minecolonies");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> EMPTY_COLONY = DEFERRED_REGISTRY_STRUCTURE.register("empty_colony", () -> new EmptyColonyStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    private static Method GETCODEC_METHOD;

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MineColoniesStructures.setupStructures();
            MineColoniesConfiguredStructures.registerConfiguredStructures();
        });
    }

    public static void setupStructures() {
        MineColoniesStructures.setupMapSpacingAndLand((StructureFeature)EMPTY_COLONY.get(), new StructureFeatureConfiguration(((Integer)MineColonies.getConfig().getServer().averageEmptyColonyDistance.get()).intValue(), 20, 435989457), true);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration featureConfig, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)featureConfig).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, featureConfig);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, featureConfig);
            }
        });
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_) || ((Boolean)MineColonies.getConfig().getServer().disableEmptyColonies.get()).booleanValue()) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap map = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.OCEAN || biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || biomeCategory == Biome.BiomeCategory.DESERT) continue;
                MineColoniesStructures.associateBiomeToConfiguredStructure(map, MineColoniesConfiguredStructures.CONFIGURED_EMPTY_COLONY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            map.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                Log.getLogger().error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)EMPTY_COLONY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)EMPTY_COLONY.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            Log.getLogger().error("Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning. This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.  The two conflicting ConfiguredStructures are: {}, {} The biome that is attempting to be shared: {}", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

