/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.inventory.container.ContainerField;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.ScareCrowType;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScarecrowTileEntity
extends AbstractScarecrowTileEntity {
    private static final int MAX_RANGE = 5;
    private boolean taken = false;
    private boolean doesNeedWork = true;
    private ScarecrowFieldStage fieldStage = ScarecrowFieldStage.EMPTY;
    private int ownerId;
    @NotNull
    private String owner = "";
    private final Random random = new Random();
    private ScareCrowType type;
    @Nullable
    private IColony colony;
    private final ItemStackHandler inventory;
    protected int[] radii = new int[]{5, 5, 5, 5};

    public ScarecrowTileEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.inventory = new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return Tags.Items.SEEDS.m_8110_((Object)stack.m_41720_()) || stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof CropBlock;
            }
        };
    }

    public static int getMaxRange() {
        return 5;
    }

    @Override
    public void setRadius(Direction direction, int radius) {
        this.radii[direction.m_122416_()] = radius;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    @Override
    public int getRadius(Direction direction) {
        return this.radii[direction.m_122416_()];
    }

    @Override
    public boolean isNoPartOfField(@NotNull Level world, @NotNull BlockPos position) {
        return world.m_46859_(position) || ScarecrowTileEntity.isValidDelimiter(world.m_8055_(position.m_7494_()).m_60734_());
    }

    private static boolean isValidDelimiter(Block block) {
        return block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock;
    }

    @Override
    public BlockPos getID() {
        return this.getPosition();
    }

    @Override
    public boolean isTaken() {
        return this.taken;
    }

    @Override
    public void setTaken(boolean taken) {
        this.taken = taken;
        this.m_6596_();
    }

    @Override
    public void nextState() {
        if (this.getFieldStage().ordinal() + 1 >= ScarecrowFieldStage.values().length) {
            this.doesNeedWork = false;
            this.setFieldStage(ScarecrowFieldStage.values()[0]);
            return;
        }
        this.setFieldStage(ScarecrowFieldStage.values()[this.getFieldStage().ordinal() + 1]);
    }

    @Override
    public ScarecrowFieldStage getFieldStage() {
        return this.fieldStage;
    }

    @Override
    public void setFieldStage(ScarecrowFieldStage fieldStage) {
        this.fieldStage = fieldStage;
        this.m_6596_();
    }

    @Override
    public boolean needsWork() {
        return this.doesNeedWork;
    }

    @Override
    public void setNeedsWork(boolean needsWork) {
        this.doesNeedWork = needsWork;
        this.m_6596_();
    }

    @Override
    @Nullable
    public ItemStack getSeed() {
        if (this.inventory.getStackInSlot(0) != ItemStackUtils.EMPTY) {
            return this.inventory.getStackInSlot(0);
        }
        return null;
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    @Override
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    public int getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setOwner(int ownerId) {
        this.ownerId = ownerId;
        if (this.colony != null) {
            this.owner = this.colony.getCitizenManager().getCivilian(ownerId) == null ? "" : this.colony.getCitizenManager().getCivilian(ownerId).getName();
        }
        this.m_6596_();
    }

    @Override
    public void setOwner(int ownerId, IColonyView tempColony) {
        this.ownerId = ownerId;
        if (tempColony != null) {
            this.owner = tempColony.getCitizen(ownerId) == null ? "" : tempColony.getCitizen(ownerId).getName();
        }
        this.m_6596_();
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
        if (compound.m_128431_().contains("colony")) {
            this.setOwner(this.ownerId, IColonyManager.getInstance().getColonyView(compound.m_128451_("colony"), (ResourceKey<Level>)this.f_58857_.m_46472_()));
        }
    }

    public void m_142466_(CompoundTag compound) {
        ListTag inventoryTagList = compound.m_128437_("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundTag inventoryCompound = inventoryTagList.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        this.taken = compound.m_128471_("taken");
        this.fieldStage = ScarecrowFieldStage.values()[compound.m_128451_("stage")];
        this.radii[3] = compound.m_128441_("plot_east") ? compound.m_128451_("plot_east") : 5;
        this.radii[2] = compound.m_128441_("plot_north") ? compound.m_128451_("plot_north") : 5;
        this.radii[1] = compound.m_128441_("plot_west") ? compound.m_128451_("plot_west") : 5;
        this.radii[0] = compound.m_128441_("plot_south") ? compound.m_128451_("plot_south") : 5;
        this.ownerId = compound.m_128451_("owner");
        this.setOwner(this.ownerId);
        super.m_142466_(compound);
    }

    @NotNull
    public void m_183515_(CompoundTag compound) {
        @NotNull ListTag inventoryTagList = new ListTag();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundTag inventoryCompound = new CompoundTag();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack((ItemLike)Blocks.f_50016_, 0).m_41739_(inventoryCompound);
            } else {
                stack.m_41739_(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.m_128365_("inventory", (Tag)inventoryTagList);
        compound.m_128379_("taken", this.taken);
        compound.m_128405_("stage", this.fieldStage.ordinal());
        compound.m_128405_("plot_east", this.radii[3]);
        compound.m_128405_("plot_north", this.radii[2]);
        compound.m_128405_("plot_west", this.radii[1]);
        compound.m_128405_("plot_south", this.radii[0]);
        compound.m_128405_("owner", this.ownerId);
        if (this.colony != null) {
            compound.m_128405_("colony", this.colony.getID());
        }
    }

    public void setColony(IColony colony) {
        this.colony = colony;
    }

    @Override
    public ScareCrowType getScarecrowType() {
        if (this.type == null) {
            this.type = ScareCrowType.values()[this.random.nextInt(2)];
        }
        return this.type;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerField(id, inv, this.m_58899_());
    }

    @NotNull
    public Component m_5446_() {
        return new TextComponent(this.owner);
    }
}

