/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.AbstractTileEntityBarrel;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBarrel
extends AbstractTileEntityBarrel
implements ITickable {
    private boolean done = false;
    private int items = 0;
    private int timer = 0;
    private static final int TIMER_END = 24000;
    private static final int AVERAGE_TICKS = 20;

    public TileEntityBarrel(BlockPos pos, BlockState state) {
        super(MinecoloniesTileEntities.BARREL, pos, state);
    }

    @Override
    public void tick() {
        Level world = this.m_58904_();
        if (!world.f_46443_ && world.m_46467_() % (long)(world.f_46441_.nextInt(40) + 1) == 0L) {
            this.updateTick(world, this.m_58899_(), world.m_8055_(this.m_58899_()), new Random());
        }
    }

    public void updateTick(Level worldIn, BlockPos pos, BlockState state, Random rand) {
        if (this.getItems() == 64) {
            this.doBarrelCompostTick(worldIn, pos, state);
        }
        if (this.done) {
            ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
    }

    private void doBarrelCompostTick(Level worldIn, BlockPos pos, BlockState blockState) {
        ++this.timer;
        if (this.timer >= 1200) {
            this.timer = 0;
            this.items = 0;
            this.done = true;
            this.updateBlock(worldIn);
        }
    }

    public boolean useBarrel(Player playerIn, ItemStack itemstack) {
        if (this.done) {
            playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.compost, 6));
            this.done = false;
            return true;
        }
        CompostRecipe recipe = TileEntityBarrel.findCompostRecipe(itemstack);
        if (recipe == null) {
            return false;
        }
        if (this.items == 64) {
            playerIn.m_6352_((Component)new TranslatableComponent("entity.barrel.working"), playerIn.m_142081_());
            return false;
        }
        this.consumeNeededItems(itemstack, recipe);
        return true;
    }

    private void consumeNeededItems(ItemStack itemStack, CompostRecipe recipe) {
        int factor = recipe.getStrength();
        int availableItems = itemStack.m_41613_() * factor;
        int neededItems = 64 - this.items;
        int itemsToRemove = Math.min(neededItems, availableItems);
        this.items += itemsToRemove;
        ItemStackUtils.changeSize(itemStack, -(itemsToRemove /= factor));
    }

    @Nullable
    private static CompostRecipe findCompostRecipe(ItemStack itemStack) {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().get(itemStack.m_41720_());
    }

    public void updateBlock(Level worldIn) {
        BlockState barrel = this.f_58857_.m_8055_(this.f_58858_);
        if (barrel.m_60734_() == ModBlocks.blockBarrel) {
            worldIn.m_46597_(this.f_58858_, AbstractBlockBarrel.changeStateOverFullness(this, barrel));
            this.m_6596_();
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("items", this.items);
        compound.m_128405_("timer", this.timer);
        compound.m_128379_("done", this.done);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items = compound.m_128451_("items");
        this.timer = compound.m_128451_("timer");
        this.done = compound.m_128471_("done");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public final void handleUpdateTag(CompoundTag tag) {
        this.items = tag.m_128451_("items");
        this.timer = tag.m_128451_("timer");
        this.done = tag.m_128471_("done");
    }

    @Override
    public int getItems() {
        return this.items;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean checkIfWorking() {
        return this.items == 64;
    }

    @Override
    public boolean addItem(ItemStack item) {
        CompostRecipe recipe = TileEntityBarrel.findCompostRecipe(item);
        if (recipe != null && this.items < 64) {
            this.consumeNeededItems(item, recipe);
            this.updateBlock(this.f_58857_);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack retrieveCompost(double multiplier) {
        if (this.done) {
            this.done = false;
            this.updateBlock(this.f_58857_);
            return new ItemStack((ItemLike)ModItems.compost, (int)(6.0 * multiplier));
        }
        return ItemStack.f_41583_;
    }
}

