/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.client.gui;

import beyond_earth_giselle_addon.client.util.SkullRenderUtils;
import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.network.AbstractMessage;
import beyond_earth_giselle_addon.common.network.AddonNetwork;
import beyond_earth_giselle_addon.common.network.FlagEditMessageSave;
import beyond_earth_giselle_addon.common.util.GameProfileUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.mrscauthd.beyond_earth.flag.FlagTileEntity;
import org.apache.commons.lang3.StringUtils;

public class FlagEditScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = FlagEditScreen.texture("back");
    public static final Component TITLE = FlagEditScreen.language("title", new Object[0]);
    public static final Component VERIFY = FlagEditScreen.language("verify", new Object[0]);
    public static final Component VERIFYING = FlagEditScreen.language("verifying", new Object[0]);
    public static final Component SAVE = FlagEditScreen.language("save", new Object[0]);
    private final FlagTileEntity blockEntity;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected EditBox valueTextField;
    protected Button verityButton;
    protected Button saveButton;
    private String lastRequestText;
    private Thread requestThread;
    private GameProfile gameProfile;
    private int verifyCounter;
    private boolean changed;
    private boolean willClose;

    public static ResourceLocation texture(String name) {
        return BeyondEarthAddon.rl("textures/gui/flag_edit_" + name + ".png");
    }

    public static TranslatableComponent language(String key, Object ... objects) {
        return new TranslatableComponent(BeyondEarthAddon.tl("gui", "flag_edit." + key), objects);
    }

    public FlagEditScreen(FlagTileEntity blockEntity) {
        this(blockEntity, (Component)FlagEditScreen.language("title", new Object[0]));
    }

    public FlagEditScreen(FlagTileEntity blockEntity, Component text) {
        super(text);
        this.blockEntity = blockEntity;
        GameProfile gameProfile = blockEntity.getPlayerProfile();
        this.imageWidth = 210;
        this.imageHeight = 138;
        this.lastRequestText = gameProfile != null ? gameProfile.getName() : "";
        this.requestThread = null;
        this.setGameProfile(gameProfile);
        this.verifyCounter = 0;
        this.setChanged(false);
    }

    protected void m_7856_() {
        super.m_7856_();
        int imageWidth = this.getImageWidth();
        int imageHeight = this.getImageHeight();
        this.leftPos = (this.f_96543_ - imageWidth) / 2;
        this.topPos = (this.f_96544_ - imageHeight) / 2;
        int buttonWidth = 40;
        int buttonHeight = 20;
        this.verityButton = (Button)this.m_142416_((GuiEventListener)new Button(this.leftPos + imageWidth - buttonWidth - 10, this.topPos + 25, buttonWidth, buttonHeight, VERIFY, this::performClick));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new Button(this.verityButton.f_93620_, this.topPos + imageHeight - buttonHeight - 10, this.verityButton.m_5711_(), this.verityButton.m_93694_(), SAVE, this::performClick));
        EditBox prevValueTestFie = this.getValueTextField();
        int valueTextLeft = this.leftPos + 10;
        this.valueTextField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, valueTextLeft, this.topPos + 25, this.verityButton.f_93620_ - 5 - valueTextLeft, 20, (Component)new TextComponent("")));
        this.valueTextField.m_94199_(65535);
        if (prevValueTestFie != null) {
            this.valueTextField.m_94144_(prevValueTestFie.m_94155_());
        } else {
            this.valueTextField.m_94144_(this.lastRequestText);
        }
    }

    public void m_96624_() {
        super.m_96624_();
        this.verifyCounter = (this.verifyCounter + 1) % 6;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 257 || p_231046_1_ == 335) {
            if (this.isDirty()) {
                this.performClick(this.getVerityButton());
            } else if (this.isChanged()) {
                this.performClick(this.getSaveButton());
            }
        }
        return super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(stack, mouseX, mouseY, partialTicks);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.renderSkull(stack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(stack, TITLE, (float)(this.getLeftPos() + 10), (float)(this.getTopPos() + 10), -12566464);
        if (this.isWillClose()) {
            this.m_7379_();
        }
    }

    public void performClick(Button button) {
        if (button == this.getSaveButton()) {
            if (!this.isChanged()) {
                return;
            }
            GameProfile gameProfile = this.getGameProfile();
            if (gameProfile != null) {
                AddonNetwork.sendToServer((AbstractMessage)new FlagEditMessageSave(this.getBlockEntity(), gameProfile));
            }
            this.setWillClose(true);
        } else if (button == this.getVerityButton()) {
            String text = this.getValueTextField().m_94155_();
            if (!this.isDirty(text)) {
                return;
            }
            this.lastRequestText = text;
            this.setGameProfile(null);
            if (this.requestThread != null) {
                try {
                    this.requestThread.interrupt();
                    this.requestThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.requestThread = new Thread(() -> this.runFillTextures(text));
            this.requestThread.start();
        }
    }

    public boolean isDirty() {
        return this.isDirty(this.getValueTextField().m_94155_());
    }

    public boolean isDirty(String text) {
        return !StringUtils.isEmpty((CharSequence)text) && !StringUtils.equalsIgnoreCase((CharSequence)this.lastRequestText, (CharSequence)text);
    }

    private void runFillTextures(String text) {
        GameProfileUtils.fillTextures(new GameProfile(null, text), text, gameProfile -> {
            this.setGameProfile((GameProfile)gameProfile);
            this.requestThread = null;
            this.setChanged(true);
        });
    }

    protected void renderBg(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        EditBox valueTextField = this.getValueTextField();
        this.m_7522_((GuiEventListener)valueTextField);
        valueTextField.m_94178_(true);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(stack, this.getLeftPos(), this.getTopPos(), 0, 0, this.getImageWidth(), this.getImageHeight());
        this.getVerityButton().f_93623_ = this.isDirty();
        this.getSaveButton().f_93623_ = this.isChanged();
    }

    protected void renderSkull(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        GameProfile gameProfile = this.getGameProfile();
        EditBox valueTextField = this.getValueTextField();
        int x = valueTextField.f_93620_;
        int y = valueTextField.f_93621_ + valueTextField.m_93694_() + 10;
        if (gameProfile == null && this.requestThread != null) {
            MutableComponent text = new TextComponent("").m_7220_(VERIFYING).m_130946_(StringUtils.repeat((char)'.', (int)(this.verifyCounter + 1)));
            this.f_96547_.m_92889_(stack, (Component)text, (float)x, (float)y, -12566464);
            return;
        }
        try {
            float scale = 128.0f;
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_(scale, scale, scale);
            SkullRenderUtils.renderSkinModel(stack, gameProfile, 180.0f, 0.0f);
            stack.m_85849_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FlagTileEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public EditBox getValueTextField() {
        return this.valueTextField;
    }

    public Button getVerityButton() {
        return this.verityButton;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    @Nullable
    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(@Nullable GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isWillClose() {
        return this.willClose;
    }

    public void setWillClose(boolean willClose) {
        this.willClose = willClose;
    }
}

