/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.block.entity;

import beyond_earth_giselle_addon.common.adapter.FuelAdapter;
import beyond_earth_giselle_addon.common.adapter.FuelAdapterCreateEntityEvent;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.fluid.FluidUtil3;
import beyond_earth_giselle_addon.common.inventory.FuelLoaderContainerMenu;
import beyond_earth_giselle_addon.common.registries.AddonBlockEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluid.FluidUtil2;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.NamedComponentRegistry;

public class FuelLoaderBlockEntity
extends AbstractMachineBlockEntity {
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int SLOTS_FLUID = 2;
    public static final int SLOT_FLUID_SOURCE = 0;
    public static final int SLOT_FLUID_SINK = 1;
    private FluidTank fluidTank;
    private IItemHandlerModifiable fluidItemHandler;

    public FuelLoaderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.FUEL_LOADER.get(), pos, state);
    }

    public int m_6893_() {
        return 1;
    }

    public boolean hasSpaceInOutput() {
        return true;
    }

    protected void createItemHandlers() {
        super.createItemHandlers();
        IItemHandlerModifiable itemHandler = this.getItemHandler();
        this.fluidItemHandler = new RangedWrapper(itemHandler, this.getSlotFluidStart(), this.getSlotFluidEnd());
    }

    protected int getInitialInventorySize() {
        return super.getInitialInventorySize() + this.getSlotsFluid();
    }

    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
        super.createFluidHandlers(registry);
        this.fluidTank = new FluidTank((Integer)AddonConfigs.Common.machines.fuelLoader_capacity.get(), this::testFluidStack){

            protected void onContentsChanged() {
                super.onContentsChanged();
                FuelLoaderBlockEntity.this.m_6596_();
            }
        };
        registry.put((Object)this.fluidTank);
    }

    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        super.getSlotsForFace(direction, slots);
        slots.add(this.getSlotFluidSource());
    }

    protected boolean onCanPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (index == this.getSlotFluidSource()) {
            return FluidUtil3.canDrainStack(stack, this::testFluidStack);
        }
        if (index == this.getSlotFluidSink()) {
            FluidStack fluidStack = this.getFluidTank().getFluid();
            return FluidUtil2.canFill((ItemStack)stack, (Fluid)fluidStack.getFluid());
        }
        return super.onCanPlaceItemThroughFace(index, stack, direction);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (index == this.getSlotFluidSource()) {
            return !FluidUtil3.canDrainStack(stack, this::testFluidStack);
        }
        if (index == this.getSlotFluidSink()) {
            FluidStack fluidStack = this.getFluidTank().getFluid();
            return !FluidUtil2.canFill((ItemStack)stack, (Fluid)fluidStack.getFluid());
        }
        return super.m_7157_(index, stack, direction);
    }

    @Nullable
    public AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return new FuelLoaderContainerMenu(windowId, inv, this);
    }

    protected void tickProcessing() {
        this.processTank();
        boolean worked = this.exchangeFuelItemAround();
        if (worked) {
            this.setProcessedInThisTick();
        }
    }

    public void processTank() {
        IItemHandlerModifiable itemHandler = this.getItemHandler();
        int transferPerTick = this.getTransferPerTick();
        FluidTank fluidTank = this.getFluidTank();
        FluidUtil2.drainSource((IItemHandlerModifiable)itemHandler, (int)this.getSlotFluidSource(), (IFluidHandler)fluidTank, (int)transferPerTick);
        FluidUtil2.fillSink((IItemHandlerModifiable)itemHandler, (int)this.getSlotFluidSink(), (IFluidHandler)fluidTank, (int)transferPerTick);
    }

    public int getTransferPerTick() {
        return (Integer)AddonConfigs.Common.machines.fuelLoader_transfer.get();
    }

    public boolean exchangeFuelItemAround() {
        Level level = this.m_58904_();
        AABB workingArea = this.getWorkingArea();
        List entities = level.m_45933_(null, workingArea);
        boolean worked = false;
        for (Entity entity : entities) {
            FuelAdapter adapter = (FuelAdapter)new FuelAdapterCreateEntityEvent(entity).resolve();
            if (!this.exchangeFuelItem(adapter)) continue;
            worked = true;
        }
        return worked;
    }

    public AABB getRenderBoundingBox() {
        return this.getWorkingArea();
    }

    public boolean isWorkingAreaVisible() {
        return this.getTileData().m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.getTileData().m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, visible);
            this.m_6596_();
        }
    }

    public int getWorkingRange() {
        return (Integer)AddonConfigs.Common.machines.fuelLoader_range.get();
    }

    public AABB getWorkingArea() {
        return this.getWorkingArea(this.getWorkingRange());
    }

    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public AABB getWorkingArea(BlockPos pos, double range) {
        double half = range / 2.0;
        return new AABB(pos).m_82377_(range, half, range).m_82386_(0.0, half, 0.0);
    }

    public boolean exchangeFuelItem(FuelAdapter<? extends Entity> adapter) {
        if (adapter == null) {
            return false;
        }
        FluidTank fluidTank = this.getFluidTank();
        FluidStack draining = fluidTank.getFluid();
        if (draining.isEmpty()) {
            return false;
        }
        int filling = adapter.fill(draining.getAmount(), IFluidHandler.FluidAction.SIMULATE);
        if (filling <= 0) {
            return false;
        }
        fluidTank.drain(filling, IFluidHandler.FluidAction.EXECUTE);
        adapter.fill(filling, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    public boolean testFluidStack(FluidStack fluidStack) {
        return this.testFluid(fluidStack.getFluid());
    }

    public boolean testFluid(Fluid fluid) {
        return Methods.tagCheck((Fluid)fluid, (ResourceLocation)ModInit.FLUID_VEHICLE_FUEL_TAG);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int getSlotFluidStart() {
        return 0;
    }

    public int getSlotFluidEnd() {
        return this.getSlotFluidStart() + this.getSlotsFluid();
    }

    public int getSlotsFluid() {
        return 2;
    }

    public int getSlotFluidSource() {
        return this.getSlotFluidStart() + 0;
    }

    public int getSlotFluidSink() {
        return this.getSlotFluidStart() + 1;
    }

    public IItemHandlerModifiable getFluidItemHandler() {
        return this.fluidItemHandler;
    }
}

